;  "Cosmic Raiders" #2019
;  For Bally Arcade/Astrocade
;  
;  Designed and Programmed by Bob Ogdon
;  Audio by Scot L. Norris
;  Graphics by Julie Malan & Lisa Natting
;  Developed by Action Graphics
;
; 
;  Disassembly Started September 5, 2016 by AJT
;
;  This program can be assembled using ZMAC.  Make sure that HVGLIB.H
;  is in the same directory and then type:
;      zmac -i -m -o cosmic.bin -x cosmic.lst cosmic.asm
;
;
;  Version History:
;    .01 (Sept. 8, 2011) -  First Distributed version.
;                           VERY rough.  Only partially dissassembled.
;                           Graphics not yet found.  Mostly uncommented. 
;                           Distributed to get some help/advice.
;    .02 (Sept. 10, 2011) - Still very rough, but much more of the code
;                           has been disassembled.  Many of the graphic
;                           patterns have been found.  Most code is still
;                           not commented.                    
 
        INCLUDE "HVGLIB.H"      ; Home Video Game Library

INTEN1  EQU     $4F11           ; Player 1 Intensity (0-9)
INTEN2  EQU     $4F12           ; Player 2 Intensity (0-9)
INTEN3  EQU     $4F13           ; Player 3 Intensity (0-9)
INTEN4  EQU     $4F14           ; Player 3 Intensity (0-9)  
NUMPLA  EQU     $4FF3           ; Number of Players
SHIPS   EQU     $4FF4           ; Number of Ships
NOLINE  EQU     $60             ; NUMBER OF DISPLAYED LINES = 96

        ORG     FIRSTC

        JP      L3E72           ; Autostart "Cosmic Raiders"

        DB      $FF
        DB      $FF
        DB      $FF
        DB      $FF
        DB      $C3
        DB      $FF
        DB      $FF
        DB      $C3
        DB      $00
        DB      $00
        DB      $C3
        DB      $00
        DB      $00
        DB      $C3
        DB      $00
        DB      $00
        DB      $C3
        DB      $00
        DB      $00
        DB      $C3
        DB      $00
        DB      $00

L2019:  SYSSUK  FILL             ;  UPI FILL memory with data
        DW      NORMEM           ;  ... NORmal MEMory start
        DW      $0E80            ;  ... Byte Count = 3712
        DB      $00              ;  ... Data = 0
        ;
        LD      (WASTE),A
        DEC     A
        LD      (TIMOUT),A
        SYSTEM  EMUSIC           ;  UPI End playing MUSIC
        ;
        SYSSUK  SETOUT           ;  UPI SET some OUTput ports
        DB      NOLINE*2 - 1     ;  ... VERBL*2 = 191 ($BF) - Display 96 lines
        DB      $29              ;  ... HORCB/4 = 41  (Horizontal Color Boundary)
        DB      $08              ;  ... INMODE = 8, Light Pen interrupt DISABLE
                                 ;                  and Screen interrupt ENABLE
        ;
        SYSSUK  COLSET           ;  UPI COLors SET
        DW      $0013            ;  ... On-Board ROM MENU COLORS table
        ;
        SYSTEM  ACTINT           ;  UPI ACTivate sub timer INTerrupts
        ;
        RET     

L2035:  PUSH    DE
        LD      DE,$0000
        EX      DE,HL
        OR      A
        SBC     HL,DE
        POP     DE
        RET     
        
L203F:  LD      E,A
        LD      D,$00
        ADD     HL,DE
        ADD     HL,DE
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        RET     
        ;
L2048:  ADD     A,C
        DAA     
        OR      A
        SBC     HL,DE
        JR      NC,L2048
        ADD     HL,DE
        SUB     C
        DAA     
        RET     
        
L2053:  XOR     A
        LD      C,$01
        LD      DE,$2710
        CALL    L2048
        LD      (IY+$02),A
        XOR     A
        LD      C,$10
        LD      DE,$03E8
        CALL    L2048
        LD      C,$01
        LD      DE,$0064
        CALL    L2048
        LD      (IY+$01),A
        XOR     A
        LD      C,$10
        LD      DE,$000A
        CALL    L2048
        ADD     A,L
        LD      (IY+$00),A
        RET     

L2081:  DI      
        PUSH    AF
        XOR     A
        LD      ($4FB0),A
        INC     A
        LD      ($4FB1),A
        POP     AF
        EI      
        RET     
        ;
L208E:  DI      
        PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        XOR     A
        LD      ($4FB1),A
        LD      HL,$4FB0
        OR      (HL)
        JR      NZ,L20A3
        POP     HL
        POP     DE
        POP     BC
        POP     AF
        EI      
        RET     
        ;
L20A3:  EXX     
        EX      AF,AF'
        PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        PUSH    IY
        PUSH    IX
        LD      HL,($4FAF)
        XOR     A
        LD      ($4FB0),A
        JP      (HL)
        ;
;  User MACRO routine 00  
L20B5:  EXX     
        LD      HL,L20C3
        PUSH    HL
        LD      HL,($010D)
        PUSH    HL
        EXX     
        CALL    L2081
        RET     
        ;
L20C3:  CALL    L208E
        RET     
        ;
L20C7:  DW      L20B5              ;  User MACRO routine 00 (Jump Address)
        ;
L20C9:  DB      00000011B          ;  User MACRO Routine 00 - E,D        
        ;  
L20CA:  DB      $57
L20CB:  DI      
        LD      A,D
        LD      D,$00
        LD      HL,$4FD5
        ADD     HL,DE
        LD      (HL),A
        LD      HL,$4FB2
        ADD     HL,DE
        ADD     HL,DE
        POP     DE
        LD      (HL),E
        INC     HL
        LD      (HL),D
        EI      
        RET     
        
L20DF:  LD      HL,$4F9E
        XOR     A
        CP      (HL)
        JR      Z,L20E8
        POP     HL
        RET     
        ;
L20E8:  LD      HL,$4F9D
        LD      BC,$0011
        XOR     A
L20EF:  LD      (HL),A
        CPD     
        JP      PE,L20EF
        LD      BC,$0818
L20F8:  OUT     (C),A
        DJNZ    L20F8
        RET     
        ;
L20FD:  LD      HL,$4F9E
        LD      (HL),$00
        CALL    L20DF
        LD      HL,($4F9F)
        LD      A,L
        OR      H
        JR      Z,L210D
        JP      (HL)
L210D:  RET
        ;     
L210E:  LD      HL,$0000
        LD      ($4F9F),HL
        JR      L20FD
L2116:  POP     HL
        LD      ($4F9F),HL
        PUSH    HL
        JR      L20DF
L211D:  LD      HL,$4F9E
        LD      (HL),$01
        RET     
        ;
L2123:  XOR     A
        CP      (IY+$04)
        JR      Z,L2174
        DEC     (IY+$04)
        JR      NZ,L2174
        LD      A,(IY+$05)
        LD      (IY+$04),A
        LD      A,(IY+$06)
        AND     $7F
        LD      C,A
        LD      A,(IY+$00)
        CP      (IY+$02)
        JR      C,L2169
        CP      (IY+$03)
        JR      NC,L2150
        ADD     A,(IY+$01)
L214A:  LD      (IY+$00),A
        OUT     (C),A
        RET     

L2150:  BIT     7,(IY+$06)
        JR      NZ,L2162
        XOR     A
        SUB     (IY+$01)
        LD      (IY+$01),A
        ADD     A,(IY+$00)
        JR      L214A
L2162:  LD      A,(IY+$02)
        JR      L214A
        JR      L2174
L2169:  BIT     7,(IY+$06)
        JR      Z,$2156
        LD      A,(IY+$03)
        JR      L214A
L2174:  RET     

L2175:  XOR     A
        LD      HL,$4F9D
        CP      (HL)
        RET     Z

        LD      HL,($4F9B)
        LD      A,L
        OR      H
        RET     Z

        DEC     HL
        LD      ($4F9B),HL
        LD      A,L
        OR      H
        JP      Z,L20FD
        LD      IY,$4F8D
        CALL    L2123
        LD      IY,$4F94
        JP      L2123

;  SENTRY RETURN Code SCT0 Handler
;  Counter-Timer 0 has counted down
L2198:  XOR     A
        ;
L2199:  LD      HL,$4FB2
        CALL    L203F
        LD      A,E
        OR      D
        JR      Z,L21A5
        EX      DE,HL
        JP      (HL)
L21A5:  RET     
        
;  SENTRY RETURN Code SCT1 Handler
;  Counter-Timer 1 has counted down
L21A6:  LD      A,$01
        JR      L2199
;  SENTRY RETURN Code SCT2 Handler
;  Counter-Timer 2 has counted down
L21AA:  LD      A,$02
        JR      L2199
;  SENTRY RETURN Code SCT3 Handler
;  Counter-Timer 3 has counted down
L21AE:  LD      A,$03
        JR      L2199
;  SENTRY RETURN Code SCT4 Handler
;  Counter-Timer 4 has counted down
L21B2:  LD      A,$04
        JR      L2199
;  SENTRY RETURN Code SCT5 Handler
;  Counter-Timer 5 has counted down
L21B6:  LD      A,$05
        JP      L2199
;  SENTRY RETURN Code SCT6 Handler
;  Counter-Timer 6 has counted down
L21BB:  LD      A,$06
        JP      L2199

;  SENTRY RETURN Code SCT7 Handler
;  Counter-Timer 7 has counted down
L21C0:  LD      A,$07
        JP      L2199

;  DOIT table
L21C5:  JMPd    SCT7,L21C0,0     ; JMP - $08 (SCT7), Counter-Timer 7 has counted down    
        JMPd    SCT0,L2198,0     ; JMP - $01 (SCT0), Counter-Timer 0 has counted down
        JMPd    SCT1,L21A6,0     ; JMP - $02 (SCT1), Counter-Timer 1 has counted down
        JMPd    SCT2,L21AA,0     ; JMP - $03 (SCT2), Counter-Timer 2 has counted down
        JMPd    SCT3,L21AE,0     ; JMP - $04 (SCT3), Counter-Timer 3 has counted down
        JMPd    SCT4,L21B2,0     ; JMP - $05 (SCT4), Counter-Timer 4 has counted down
        JMPd    SCT5,L21B6,0     ; JMP - $06 (SCT5), Counter-Timer 5 has counted down
        JMPd    SCT6,L21BB,ENDx  ; JMP - $07 (SCT6), Counter-Timer 6 has counted down
        
L21DE:  PUSH    HL
        POP     DE
        INC     DE
        INC     DE
        INC     DE
        INC     DE
        LD      (HL),E
        INC     HL
        LD      (HL),D
        INC     HL
        LD      (HL),E
        INC     HL
        LD      (HL),D
        RET     
        ;
L21EC:  CALL    L2081
        PUSH    DE
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        PUSH    DE
        POP     IY
        INC     HL
        LD      C,(IY+$00)
        LD      E,C
        LD      B,(IY+$01)
        LD      D,B
        LD      A,(HL)
        INC     HL
        CP      C
        JR      NZ,L2206
        LD      A,(HL)
        CP      B
L2206:  JR      NZ,L220D
        PUSH    IY
        POP     BC
        INC     BC
        INC     BC
L220D:  INC     BC
        INC     BC
        LD      A,(IY+$02)
        CP      C
        LD      A,(IY+$03)
        JR      NZ,L2219
        CP      B
L2219:  JR      NZ,L2223
        POP     DE
        LD      HL,$0001
        CALL    L208E
        RET     

L2223:  POP     HL
        LD      A,L
        LD      (DE),A
        INC     DE
        LD      A,H
        LD      (DE),A
        LD      (IY+$00),C
        LD      (IY+$01),B
        LD      HL,$0000
        CALL    L208E
        RET     

L2236:  CALL    L2081
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        PUSH    DE
        POP     IY
        INC     HL
        LD      C,(IY+$02)
        LD      B,(IY+$03)
        LD      A,(IY+$00)
        CP      C
        JR      NZ,L2250
        LD      A,(IY+$01)
        CP      B
L2250:  JR      NZ,L2259
        LD      HL,$0001
        CALL    L208E
        RET     

L2259:  LD      A,(BC)
        LD      E,A
        INC     BC
        LD      A,(BC)
        LD      D,A
        DEC     BC
        LD      A,(HL)
        INC     HL
        CP      C
        JR      NZ,L2266
        LD      A,(HL)
        CP      B
L2266:  JR      NZ,L226D
        PUSH    IY
        POP     BC
        INC     BC
        INC     BC
L226D:  INC     BC
        INC     BC
        LD      (IY+$02),C
        LD      (IY+$03),B
        LD      HL,$0000
        CALL    L208E
        RET     

;  These next 8 bytes look like a table of 4 RAM addresses to me ??
L227C:  DW      $4F52
        DW      $4F70
L2280:  DW      $4F32
        DW      $4F50
L2284:  BIT     2,(IX+$01)
        RET     NZ
        SET     2,(IX+$01)
        LD      A,($4F7A)
        CP      (IX+$0B)
        JR      NC,L229E
        LD      HL,$4F75
        INC     (HL)
        LD      HL,L2280
        JR      L22A5
L229E:  LD      HL,$4F76
        INC     (HL)
        LD      HL,L227C
L22A5:  PUSH    IX
        POP     DE
        CALL    L21EC
        LD      A,L
        OR      H
        JR      Z,L22B6
L22AF:  LD      A,R
        OUT     ($00),A
        JP      L22AF
L22B6:  RET     

L22B7:  DB      $E1
        DB      $D1
        DB      $FD
        DB      $E5
        DB      $C5
        DB      $CD
        DB      $EC
        DB      $21
        DB      $C1
        DB      $FD
        DB      $E1
        DB      $E5
        DB      $FD
        DB      $E9
        DB      $E1
        DB      $FD
        DB      $E5
        DB      $C5
        DB      $CD
        DB      $36
        DB      $22
        DB      $C1
        DB      $FD
        DB      $E1
        DB      $7D
        DB      $B4
        DB      $20
        DB      $01
        DB      $D5
        DB      $E5
        DB      $FD
        DB      $E9
L22D7:  PUSH    DE
        POP     IX
        RES     2,(IX+$01)
        BIT     7,(IX+$01)
        RET     Z
L22E3:  LD      A,($4FAE)
        LD      C,A
        SUB     (IX+$14)
        LD      B,(IX+$15)
        CP      B
        JR      C,L22F1
        LD      A,B
L22F1:  LD      C,(IX+$16)
        CP      C
        JP      C,L2321
        LD      B,$00
L22FA:  SUB     C
        INC     B
        CP      C
        JP      NC,L22FA
        LD      C,A
        LD      A,($4FAE)
        SUB     C
        LD      (IX+$14),A
        LD      (IX+$02),B
        LD      HL,L2321
        PUSH    HL
        LD      L,(IX+$0F)
        LD      H,(IX+$10)
        LD      DE,$0003
        ADD     HL,DE
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        EX      DE,HL
        CALL    L2081
        JP      (HL)
        ;
L2321:  CALL    L208E
        BIT     7,(IX+$01)
        CALL    NZ,L2284
        RET     
        ;
L232C:  PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        EXX     
        EX      AF,AF'
        PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        PUSH    IY
        PUSH    IX
        LD      A,($4F7D)        ; Screen Line ??
        OUT     (INLIN),A        ; Port $0E, INterrupt LINe Register
        LD      A,$4F            ; High Order Byte Address of Interrupt Vector
        LD      I,A              ; Load Interrupt Vector Register
        LD      A,$8A            ; Get Low Order Byte Address
        OUT     (INFBK),A        ; Port $0D, INterrupt FeedBacK Register
        LD      HL,$4FAE
        INC     (HL)
        CALL    L2175
        LD      A,($4FB1)
        OR      A
        JR      Z,L2360
        LD      DE,L2360
        LD      HL,$4FAF
        LD      (HL),E
        INC     HL
        LD      (HL),D
        JP      L23B1
        ;
L2360:  DI      
        LD      BC,$0FFF
        LD      HL,$4FC2
        CALL    CTIMER           ; Custom TIMERs
        LD      A,($4F79)
        CP      $00
        JP      NZ,L23B1
        LD      A,$01
        LD      ($4F79),A
        XOR     A
        LD      ($4F72),A
        LD      A,($4F76)
        LD      ($4F74),A
        EI      
L2382:  LD      A,($4F79)
        CP      $01
        JR      NZ,L23AC
        LD      A,($4F72)
        OR      A
        JR      NZ,L23AC
        LD      A,($4F74)
        OR      A
        JR      Z,L23AC
        LD      HL,L227C
        CALL    L2236
        LD      A,L
        OR      H
        JR      NZ,L23AC
        LD      HL,$4F76
        DEC     (HL)
        LD      HL,$4F74
        DEC     (HL)
        CALL    L22D7
        JR      L2382
L23AC:  LD      A,$00
        LD      ($4F79),A
L23B1:  POP     IX
        POP     IY
        POP     HL
        POP     DE
        POP     BC
        POP     AF
        EX      AF,AF'
        EXX     
        POP     HL
        POP     DE
        POP     BC
        POP     AF
        EI      
        RET     

L23C1:  DI      
        LD      A,$08
        OUT     (INMOD),A       ; Port $0F, INterrupt MODe Register [Screen Ints. only]
        IM      2               ; Set Interrupt Mode 2 Condition
        CALL    L232C
        DI      
        RET     
        ;
L23CD:  PUSH    AF
        LD      A,($4F7B)
        OUT     ($0F),A
        LD      A,$4F
        LD      I,A
        LD      A,$86
        OUT     ($0D),A
        LD      A,($4F78)
        CP      $01
        JR      NZ,L23E7
        LD      A,$02
        LD      ($4F78),A
L23E7:  POP     AF
        EI      
        RET     

L23EA:  AND     $FC
        LD      B,A
        LD      A,D
        LD      C,A
        LD      L,H
        LD      H,$00
        ADD     HL,HL
        ADD     HL,HL
        ADD     HL,HL
        LD      D,H
        LD      E,L
        ADD     HL,HL
        ADD     HL,HL
        ADD     HL,DE
        SRL     A
        SRL     A
        LD      E,A
        LD      D,$00
        ADD     HL,DE
        LD      A,C
        AND     $03
        BIT     6,B
        JR      Z,L240E
        NEG     
        JR      NZ,L240E
        DEC     HL
L240E:  AND     $03
        OR      B
        RET     

L2412:  OUT     (MAGIC),A        ; write MAGIC register
        BIT     6,A
        JR      Z,L242D
L2418:  PUSH    DE
        PUSH    HL
L241A:  LD      A,(BC)
        LD      (HL),A
        DEC     HL
        INC     BC
        DEC     E
        JR      NZ,L241A
        LD      (HL),E
        POP     HL
        LD      DE,$0028
        ADD     HL,DE
        POP     DE
        DEC     D
        JR      NZ,L2418
        JR      L2440
L242D:  PUSH    DE
        PUSH    HL
L242F:  LD      A,(BC)
        LD      (HL),A
        INC     HL
        INC     BC
        DEC     E
        JR      NZ,L242F
        LD      (HL),E
        POP     HL
        LD      DE,$0028
        ADD     HL,DE
        POP     DE
        DEC     D
        JR      NZ,L242D
L2440:  IN      A,($08)
        RET     

L2443:  LD      L,(IX+$11)
        LD      H,(IX+$12)
        INC     HL
        INC     HL
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        INC     HL
        LD      B,H
        LD      C,L
        LD      L,(IX+$0D)
        LD      H,(IX+$0E)
        IN      A,($08)
        LD      A,(IX+$00)
        CALL    L2412
        RET     

L2460:  LD      L,(IX+$11)
        LD      H,(IX+$12)
        LD      C,(IX+$00)
        LD      A,(IX+$06)
        BIT     6,C
        JR      Z,L2473
        ADD     A,(HL)
        JR      L2474
L2473:  SUB     (HL)
L2474:  INC     HL
        LD      D,A
        LD      A,(IX+$0B)
        SUB     (HL)
        INC     HL
        PUSH    HL
        LD      H,A
        IN      A,($08)
        LD      A,C
        CALL    L23EA
        LD      (IX+$00),A
        EX      (SP),HL
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        INC     HL
        LD      B,H
        LD      C,L
        POP     HL
        LD      (IX+$0E),H
        LD      (IX+$0D),L
        JP      L2412

L2497:  LD      A,(IX+$00)
        LD      H,(IX+$0B)
        LD      D,(IX+$06)
        LD      A,(IX+$00)
        CALL    L23EA
        LD      (IX+$0E),H
        LD      (IX+$0D),L
        LD      (IX+$00),A
L24AF:  OUT     ($0C),A
        IN      A,($08)
        LD      A,(IX+$01)
        LD      (HL),A
        XOR     A
        INC     HL
        LD      (HL),A
        IN      A,($08)
        RET     

L24BD:  LD      L,(IX+$0D)
        LD      H,(IX+$0E)
        LD      A,(IX+$00)
        JR      L24AF

;  Pattern  - Bomb (Frame 1)
;  Colors   - . = Black     2 = Yellow
;             1 = Blue      3 = Red
L24C8:  DB      $04, $05         ; X,Y Displacement
        DB      $03, $09         ; X,Y Size
        DB      $C0,$00,$C0      ; 3 . . . . . . . 3 . . .
        DB      $00,$00,$00      ; . . . . . . . . . . . .
        DB      $04,$04,$00      ; . . 1 . . . 1 . . . . .
        DB      $01,$90,$00      ; . . . 1 2 1 . . . . . .
        DB      $03,$30,$00      ; . . . 3 . 3 . . . . . .
        DB      $04,$04,$00      ; . . 1 . . . 1 . . . . .
        DB      $02,$20,$00      ; . . . 2 . 2 . . . . . .
        DB      $01,$90,$00      ; . . . 1 2 1 . . . . . .
        DB      $00,$C0,$00      ; . . . . 3 . . . . . . .

;  Pattern  - Bomb (Frame 2)
L24E7:  DB      $03,04           ; X,Y Displacement
        DB      $02,$08          ; X,Y Size
        DB      $41,$04          ; 1 . . 1 . . 1 .
        DB      $32,$30          ; . 3 . 2 . 3 . .
        DB      $08,$80          ; . . 2 . 2 . . .
        DB      $31,$30          ; . 3 . 1 . 3 . .
        DB      $05,$40          ; . . 1 1 1 . . .
        DB      $01,$00          ; . . . 1 . . . .
        DB      $0B,$80          ; . . 2 3 2 . . .
        DB      $02,$00          ; . . . 2 . . . .

L24FB:  DB      $03
        DW      $24C8            ; Pattern  Address - Bomb (Frame 1) ??

        DB      $03
        DW      $24E7            ; Pattern  Address - Bomb (Frame 2) ??

        DB      $00
        DW      $24FB            ; Start of Bomb Pattern Table ?? 

;  Pattern  - Explosion ??
L2504:  DB      $03,$03          ; X,Y Displacement
        DB      $02,$06          ; X,Y Size
        DB      $10,$00          ; . 1 . . . . . .
        DB      $21,$24          ; . 2 . 1 . 2 1 .
        DB      $00,$10          ; . . . . . 1 . .
        DB      $40,$00          ; 1 . . . . . . .
        DB      $90,$34          ; 2 1 . . . 3 1 .
        DB      $C1,$04          ; 3 . . 1 . . 1 .

L2514:  DB      $05,$04          ; X,Y Displacement
        DB      $03,$09          ; X,Y Size
        DB      $00,$20,$00      ; . . . . . 2 . . . . . .
        DB      $10,$00,$90      ; . 1 . . . . . . 2 1 . .
        DB      $20,$10,$40      ; . 2 . . . 1 . . 1 . . .
        DB      $00,$00,$00      ; . . . . . . . . . . . .
        DB      $00,$00,$30      ; . . . . . . . . . 3 . .
        DB      $40,$00,$00      ; 1 . . . . . . . . . . .
        DB      $90,$00,$00      ; 2 1 . . . . . . . . . .
        DB      $C0,$00,$D0      ; 3 . . . . . . . 3 1 . .
        DB      $00,$30,$10      ; . . . . . 3 . . . 1 . .

L2533:  DB      $14
        DW      $2504            ; Pattern Address? ??
        DB      $FE
        DW      $2514            ; Pattern Address? ??
        DB      $00
        DW      $2533            ; Start of Pattern Table ??

;  Pattern  - Energy Star (Frame 1) ??        
L253C:  DB      $04,$03          ; X,Y Displacement
        DB      $03,$08          ; X,Y Size
        DB      $00,$40,$00      ; . . . . 1 . . . . . . . 
        DB      $01,$10,$00      ; . . . 1 . 1 . . . . . .
        DB      $54,$05,$40      ; 1 1 1 . . . 1 1 1 . . .
        DB      $10,$C1,$00      ; . 1 . . 3 . . 1 . . . .
        DB      $04,$04,$00      ; . . 1 . . . 1 . . . . .
        DB      $01,$10,$00      ; . . . 1 . 1 . . . . . .
        DB      $01,$10,$00      ; . . . 1 . 1 . . . . . .
        DB      $00,$40,$00      ; . . . . 1 . . . . . . .

;  Pattern  - Energy Star (Frame 2) ??
L2558:  DB      $04,$03          ; X,Y Displacement
        DB      $03,$08          ; X,Y Size
        DB      $00,$C0,$00      ; . . . . 3 . . . . . . .
        DB      $03,$30,$00      ; . . . 3 . 3 . . . . . .
        DB      $FC,$0F,$C0      ; 3 3 3 . . . 3 3 3 . . .
        DB      $30,$C3,$00      ; . 3 . . 3 . . 3 . . . .
        DB      $0C,$0C,$00      ; . . 3 . . . 3 . . . . .
        DB      $03,$30,$00      ; . . . 3 . 3 . . . . . .
        DB      $03,$30,$00      ; . . . 3 . 3 . . . . . .
        DB      $00,$C0,$00      ; . . . . 3 . . . . . . .

;  Pattern  - Energy Star (Frame 3) ??
L2574:  DB      $04,$03          ; X,Y Displacement
        DB      $03,$08          ; X,Y Size
        DB      $00,$80,$00      ; . . . . 2 . . . . . . .
        DB      $02,$20,$00      ; . . . 2 . 2 . . . . . .
        DB      $A8,$0A,$80      ; 2 2 2 . . . 2 2 2 . . .
        DB      $20,$42,$00      ; . 2 . . 1 . . 2 . . . .
        DB      $08,$08,$00      ; . . 2 . . . 2 . . . . .
        DB      $02,$20,$00      ; . . . 2 . 2 . . . . . .
        DB      $02,$20,$00      ; . . . 2 . 2 . . . . . .
        DB      $00,$80,$00      ; . . . . 2 . . . . . . .

L2590:  DB      $04
        DW      $253C            ; Pattern Address? ??
        DB      $04
        DW      $2558            ; Pattern Address? ??
        DB      $04
        DW      $2574            ; Pattern Address? ??
        DB      $00
        DW      $2590            ; Start of Pattern Table ??

;  Pattern  - Fighter (Frame 1) ??
L259C:  DB      $05,$03          ; X,Y Displacement
        DB      $03,$07          ; X,Y Size
        DB      $00,$A0,$00      ; . . . . 2 2 . . . . . .
        DB      $0A,$0A,$00      ; . . 2 2 . . 2 2 . . . .
        DB      $A0,$00,$A0      ; 2 2 . . . . . . 2 2 . .
        DB      $00,$50,$00      ; . . . . 1 1 . . . . . .
        DB      $A0,$00,$A0      ; 2 2 . . . . . . 2 2 . .
        DB      $0A,$0A,$00      ; . . 2 2 . . 2 2 . . . .
        DB      $00,$A0,$00      ; . . . . 2 2 . . . . . .

L25B5:  DB      $05,$01          ; X,Y Displacement
        DB      $03,$03          ; X,Y Size
        DB      $00,$00,$00      ; . . . . . . . . . . . .
        DB      $55,$55,$50      ; 1 1 1 1 1 1 1 1 1 1 . .
        DB      $00,$00,$00      ; . . . . . . . . . . . .

L25C2:  DB      $03          
        DW      $259C            ; Pattern Address? ??
        DB      $03
        DW      $25B5            ; Pattern Address? ??
        DB      $00
        DW      $25C2            ; Start of Pattern Table ??

;  Pattern  - Fighter ??
L25CB:  DB      $05,$03          ; X,Y Displacement
        DB      $02,$07          ; X,Y Size
        DB      $00,$05          ; . . . . . . 1 1
        DB      $00,$24          ; . . . . . 2 1 .
        DB      $00,$50          ; . . . . 1 1 . .
        DB      $51,$11          ; 1 1 . 1 . 1 . 1
        DB      $00,$50          ; . . . . 1 1 . .
        DB      $00,$24          ; . . . . . 2 1 .
        DB      $00,$05          ; . . . . . . 1 1

L25DD:  DB      $FF
        DW      $25CB            ; Pattern Address? ??
        DB      $00
        DW      $25DD            ; Start of Pattern Table ??

L25E3:  DB      $05,$02          ; X,Y Displacement
        DB      $03,$05          ; X,Y Size
        DB      $15,$57,$C0      ; . 1 1 1 1 1 1 3 3 . . .
        DB      $04,$00,$40      ; . . 1 . . . . . 1 . . .
        DB      $D5,$55,$50      ; 3 1 1 1 1 1 1 1 1 1 . .
        DB      $01,$04,$04      ; . . . 1 . . 1 . . . 1 .
        DB      $00,$55,$5F      ; . . . . 1 1 1 1 1 1 3 3

L25F6:  DB      $05,$02          ; X,Y Displacement
        DB      $03,$04          ; X,Y Size
        DB      $55,$5F,$00      ; 1 1 1 1 1 1 3 3 . . . .
        DB      $10,$40,$40      ; . 1 . . 1 . . . 1 . . .
        DB      $D5,$55,$50      ; 3 1 1 1 1 1 1 1 1 1 . .
        DB      $00,$00,$00      ; . . . . . . . . . . . .
        
L2606:  DB      $05,$00          ; X,Y Displacement
        DB      $03,$03          ; X,Y Size
        DB      $D5,$55,$50      ; 3 1 1 1 1 1 1 1 1 1 . .
        DB      $04,$04,$04      ; . . 1 . . . 1 . . . 1 .
        DB      $01,$55,$5F      ; . . . 1 1 1 1 1 1 1 3 3

L2613:  DB      $02
        DW      $25E3            ; Pattern Address? ??
        DB      $02
        DW      $25F6            ; Pattern Address? ??
        DB      $02
        DW      $2606            ; Pattern Address? ??
        DB      $00
        DW      $2613            ; Start of Pattern Table ??

L261F:  DB      $05,$04          ; X,Y Displacement
        DB      $03,$09          ; X,Y Size
        DB      $00,$15,$40      ; . . . . . 1 1 1 1 . . .
        DB      $00,$04,$00      ; . . . . . . 1 . . . . .
        DB      $00,$54,$00      ; . . . . 1 1 1 . . . . .
        DB      $05,$03,$00      ; . . 1 1 . . . 3 . . . .
        DB      $56,$A8,$00      ; 1 1 1 2 2 2 2 . . . . .
        DB      $05,$03,$00      ; . . 1 1 . . . 3 . . . .
        DB      $00,$54,$00      ; . . . . 1 1 1 . . . . .
        DB      $00,$04,$00      ; . . . . . . 1 . . . . .
        DB      $00,$15,$40      ; . . . . . 1 1 1 1 . . .
        
L263E:  DB      $05,$04          ; X,Y Displacement
        DB      $03,$09          ; X,Y Size
        DB      $00,$15,$40      ; . . . . . 1 1 1 1 . . .
        DB      $00,$04,$00      ; . . . . . . 1 . . . . .
        DB      $00,$54,$00      ; . . . . 1 1 1 . . . . .
        DB      $05,$03,$50      ; . . 1 1 . . . 3 1 1 . .
        DB      $56,$A8,$00      ; 1 1 1 2 2 2 2 . . . . .
        DB      $05,$03,$50      ; . . 1 1 . . . 3 1 1 . .
        DB      $00,$54,$00      ; . . . . 1 1 1 . . . . .
        DB      $00,$04,$00      ; . . . . . . 1 . . . . .
        DB      $00,$15,$40      ; . . . . . 1 1 1 1 . . .
        
L265D:  DB      $05,$04          ; X,Y Displacement
        DB      $03,$09          ; X,Y Size
        DB      $00,$15,$40      ; . . . . . 1 1 1 1 . . .
        DB      $00,$04,$00      ; . . . . . . 1 . . . . .
        DB      $00,$54,$00      ; . . . . 1 1 1 . . . . .
        DB      $05,$01,$D0      ; . . 1 1 . . . 1 3 1 . .
        DB      $56,$A8,$00      ; 1 1 1 2 2 2 2 . . . . .
        DB      $05,$01,$D0      ; . . 1 1 . . . 1 3 1 . .
        DB      $00,$54,$00      ; . . . . 1 1 1 . . . . .
        DB      $00,$04,$00      ; . . . . . . 1 . . . . .
        DB      $00,$15,$40      ; . . . . . 1 1 1 1 . . .

L267C:  DB      $02
        DW      $261F            ; Pattern Address? ??
        DB      $02
        DW      $263E            ; Pattern Address? ??
        DB      $02
        DW      $265D            ; Pattern Address? ??
        DB      $00
        DW      $267C            ; Start of Pattern Table ??

L2688:  DB      $04,$05          ; X,Y Displacement
        DB      $02,$08          ; X,Y Size
        DB      $00,$C0          ; . . . . 3 . . .
        DB      $01,$00          ; . . . 1 . . . .
        DB      $04,$90          ; . . 1 . 2 1 . .
        DB      $C9,$43          ; 3 . 2 1 1 . . 3
        DB      $11,$64          ; . 1 . 1 1 2 1 .
        DB      $06,$10          ; . . 1 2 . 1 . .
        DB      $00,$40          ; . . . . 1 . . .
        DB      $03,$00          ; . . . 3 . . . .
        
L269C:  DB      $05,$05          ; X,Y Displacement
        DB      $03,$08          ; X,Y Size
        DB      $20,$30,$80      ; . 2 . . . 3 . . 2 . . .
        DB      $04,$41,$00      ; . . 1 . 1 . . 1 . . . .
        DB      $01,$24,$00      ; . . . 1 . 2 1 . . . . .
        DB      $32,$50,$C0      ; . 3 . 2 1 1 . . 3 . . .
        DB      $04,$59,$00      ; . . 1 . 1 1 2 1 . . . .
        DB      $11,$84,$00      ; . 1 . 1 2 . 1 . . . . .
        DB      $80,$11,$00      ; 2 . . . . 1 . 1 . . . .
        DB      $00,$C0,$80      ; . . . . 3 . . . 2 . . .
        
L26B8:  DB      $06,$07          ; X,Y Displacement
        DB      $03,$0B          ; X,Y Size
        DB      $C0,$03,$00      ; 3 . . . . . . 3 . . . .
        DB      $13,$20,$4C      ; . 1 . 3 . 2 . . 1 . 3 .
        DB      $08,$0C,$20      ; . . 2 . . . 3 . . 2 . .
        DB      $01,$10,$43      ; . . . 1 . 1 . . 1 . . 3
        DB      $10,$49,$04      ; . 1 . . 1 . 2 1 . . 1 .
        DB      $CC,$94,$30      ; 3 . 3 . 2 1 1 . . 3 . .
        DB      $21,$16,$48      ; . 2 . 1 . 1 1 2 1 . 2 .
        DB      $04,$61,$03      ; . . 1 . 1 2 . 1 . . . 3
        DB      $20,$04,$44      ; . 2 . . . . 1 . 1 . 1 .
        DB      $C4,$30,$20      ; 3 . 1 . . 3 . . . 2 . .
        DB      $03,$08,$CC      ; . . . 3 . . 2 . 3 . 3 .

L26DD:  DB      $09,$09          ; X,Y Displacement
        DB      $05,$10          ; X,Y Size
        DB      $00,$01,$0C,$40,$00 ; . . . . . . . 1 . . 3 . 1 . . . . . . .
        DB      $00,$48,$10,$20,$00 ; . . . . 1 . 2 . . 1 . . . 2 . . . . . .
        DB      $43,$01,$0C,$04,$00 ; 1 . . 3 . . . 1 . . 3 . . . 1 . . . . .
        DB      $04,$4C,$81,$30,$00 ; . . 1 . 1 . 3 . 2 . . 1 . 3 . . . . . .
        DB      $00,$20,$30,$01,$00 ; . . . . . 2 . . . 3 . . . . . 1 . . . .
        DB      $33,$04,$41,$0C,$00 ; . 3 . 3 . . 1 . 1 . . 1 . . 3 . . . . .
        DB      $08,$40,$20,$10,$00 ; . . 2 . 1 . . . . 2 . . . 1 . . . . . .
        DB      $03,$30,$00,$C0,$80 ; . . . 3 . 3 . . . . . . 3 . . . 2 . . .
        DB      $04,$00,$00,$21,$00 ; . . 1 . . . . . . . . . . 2 . 1 . . . .
        DB      $00,$10,$80,$0C,$00 ; . . . . . 1 . . 2 . . . . . 3 . . . . .
        DB      $44,$80,$01,$11,$00 ; 1 . 1 . 2 . . . . . . 1 . 1 . 1 . . . .
        DB      $03,$00,$C0,$80,$00 ; . . . 3 . . . . 3 . . . 2 . . . . . . .
        DB      $04,$0C,$23,$30,$00 ; . . 1 . . . 3 . . 2 . 3 . 3 . . . . . .
        DB      $00,$10,$40,$40,$40 ; . . . . . 1 . . 1 . . . 1 . . . 1 . . .
        DB      $04,$08,$02,$10,$00 ; . . 1 . . . 2 . . . . 2 . 1 . . . . . .
        DB      $00,$41,$04,$01,$00 ; . . . . 1 . . 1 . . 1 . . . . 1 . . . .

L2731:  DB      $03
        DW      $2688            ; Pattern Address? ??
        DB      $03
        DW      $269C            ; Pattern Address? ??
        DB      $03
        DW      $26B8            ; Pattern Address? ??
        DB      $FF
        DW      $26DD            ; Pattern Address? ??
        DB      $00
        DW      L2731            ; Start of Pattern Table ??

;  Pattern  - Player's Ship
;  Colors   - . = Black     2 = Yellow
;             1 = Blue      3 = Red
L2740:  DB      $05, $01         ; X,Y Displacement
        DB      $03, $04         ; X, Y Size
        DB      $28,$00,$00      ; . 2 2 . . . . . . . . .
        DB      $2A,$FF,$40      ; . 2 2 2 3 3 3 3 1 . . .
        DB      $AA,$AA,$A0      ; 2 2 2 2 2 2 2 2 2 2 . .
        DB      $22,$00,$00      ; . 2 . 2 . . . . . . . .

;  Pattern  - Player's Ship (With Rocket Exhaust, Frame 1)
L2750:  DB      $0D,$01         ; X,Y Displacement
        DB      $05,$04         ; X,Y Size
        DB      $00,$40,$28,$00,$00 ; . . . . 1 . . . . 2 2 . . . . . . . . .
        DB      $13,$0C,$2A,$FF,$40 ; . 1 . 3 . . 3 . . 2 2 2 3 3 3 3 1 . . .
        DB      $30,$13,$AA,$AA,$A0 ; . 3 . . . 1 . 3 2 2 2 2 2 2 2 2 2 2 . .
        DB      $41,$0C,$22,$00,$00 ; 1 . . 1 . . 3 . . 2 . 2 . . . . . . . .

;  Pattern  - Player's Ship (With Rocket Exhaust, Frame 2)
L2768:  DB      $0D,$01         ; X,Y Displacement
        DB      $05,$04         ; X,Y Size
        DB      $03,$10,$28,$00,$00 ; . . . 3 . 1 . . . 2 2 . . . . . . . . .
        DB      $30,$F1,$2A,$FF,$40 ; . 3 . . 3 3 . 1 . 2 2 2 3 3 3 3 1 . . .
        DB      $41,$04,$AA,$AA,$A0 ; 1 . . 1 . . 1 . 2 2 2 2 2 2 2 2 2 2 . .
        DB      $0C,$1C,$22,$00,$00 ; . . 3 . . 1 3 . . 2 . 2 . . . . . . . .

L2780:  DB      $02
        DW      $2750            ; Pattern Address? ??
        DB      $02
        DW      $2768            ; Pattern Address? ??
        DB      $00
        DW      $2780            ; Start of Pattern Table ??

;  Pattern  - Player's Ship (With Rocket Exhaust and Energy Shield, Frame 1)
L2789:  DB      $0D,$03
        DB      $05,$08
        DB      $00,$00,$77,$74,$00 ; . . . . . . . . 1 3 1 3 1 3 1 . . . . .
        DB      $00,$03,$00,$03,$74 ; . . . . . . . 3 . . . . . . . 3 1 3 1 .
        DB      $00,$41,$28,$00,$01 ; . . . . 1 . . 1 . 2 2 . . . . . . . . 1
        DB      $13,$0C,$2A,$FF,$43 ; . 1 . 3 . . 3 . . 2 2 2 3 3 3 3 1 . . 3
        DB      $30,$13,$AA,$AA,$A1 ; . 3 . . . 1 . 3 2 2 2 2 2 2 2 2 2 2 . 1
        DB      $41,$0C,$22,$00,$03 ; 1 . . 1 . . 3 . . 2 . 2 . . . . . . . 3
        DB      $00,$03,$00,$37,$74 ; . . . . . . . 3 . . . . . 3 1 3 1 3 1 .
        DB      $00,$00,$77,$40,$00 ; . . . . . . . . 1 3 1 3 1 . . . . . . .

;  Pattern  - Player's Ship (With Rocket Exhaust and Energy Shield, Frame 2)
L27B5:  DB      $0D,$03
        DB      $05,$08
        DB      $00,$00,$DD,$DC,$00 ; . . . . . . . . 3 1 3 1 3 1 3 . . . . .
        DB      $00,$01,$00,$01,$DC ; . . . . . . . 1 . . . . . . . 1 3 1 3 .
        DB      $03,$13,$28,$00,$03 ; . . . 3 . 1 . 3 . 2 2 . . . . . . . . 3
        DB      $30,$F1,$2A,$FF,$41 ; . 3 . . 3 3 . 1 . 2 2 2 3 3 3 3 1 . . 1
        DB      $41,$04,$AA,$AA,$A3 ; 1 . . 1 . . 1 . 2 2 2 2 2 2 2 2 2 2 . 3
        DB      $0C,$1C,$22,$00,$01 ; . . 3 . . 1 3 . . 2 . 2 . . . . . . . 1
        DB      $00,$01,$00,$1D,$DC ; . . . . . . . 1 . . . . . 1 3 1 3 1 3 .
        DB      $00,$00,$DD,$C0,$00 ; . . . . . . . . 3 1 3 1 3 . . . . . . .

;  Pattern  - Player's Ship (With Energy Shield, Frame 1)
L27E1:  DB      $07,$03
        DB      $04,$08
        DB      $07,$77,$40,$00 ; . . 1 3 1 3 1 3 1 . . . . . . .
        DB      $30,$00,$37,$40 ; . 3 . . . . . . . 3 1 3 1 . . .
        DB      $12,$80,$00,$10 ; . 1 . 2 2 . . . . . . . . 1 . .
        DB      $C2,$AF,$F4,$30 ; 3 . . 2 2 2 3 3 3 3 1 . . 3 . .
        DB      $4A,$AA,$AA,$10 ; 1 . 2 2 2 2 2 2 2 2 2 2 . 1 . .
        DB      $C2,$20,$00,$30 ; 3 . . 2 . 2 . . . . . . . 3 . .
        DB      $70,$03,$77,$40 ; 1 3 . . . . . 3 1 3 1 3 1 . . .
        DB      $07,$74,$00,$00 ; . . 1 3 1 3 1 . . . . . . . . .

;  Pattern  - Player's Ship (With Energy Shield, Frame 2)
L2805:  DB      $07,$03
        DB      $04,$08
        DB      $0D,$DD,$C0,$00 ; . . 3 1 3 1 3 1 3 . . . . . . .
        DB      $10,$00,$1D,$C0 ; . 1 . . . . . . . 1 3 1 3 . . .
        DB      $32,$80,$00,$30 ; . 3 . 2 2 . . . . . . . . 3 . .
        DB      $42,$AF,$F4,$10 ; 1 . . 2 2 2 3 3 3 3 1 . . 1 . .
        DB      $CA,$AA,$AA,$30 ; 3 . 2 2 2 2 2 2 2 2 2 2 . 3 . .
        DB      $42,$20,$00,$10 ; 1 . . 2 . 2 . . . . . . . 1 . .
        DB      $D0,$01,$DD,$C0 ; 3 1 . . . . . 1 3 1 3 1 3 . . .
        DB      $0D,$DC,$00,$00 ; . . 3 1 3 1 3 . . . . . . . . .

L2829:  DB      $02
        DW      $2789            ; Pattern Address? ??
        DB      $02
        DW      $27B5            ; Pattern Address? ??
        DB      $00
        DW      $2829            ; Start of Pattern Table ??

L2832:  DB      $02
        DW      $2789            ; Pattern Address? ??
        DB      $02
        DW      $27B5            ; Pattern Address? ??
        DB      $02
        DW      $2750            ; Pattern Address? ??
        DB      $02
        DW      $2768            ; Pattern Address? ??
        DB      $00
        DW      $2832            ; Start of Pattern Table ??

L2841:  DB      $80
        DW      $2927
        DB      $28
        DW      $2832

L2847:  DB      $02
        DW      $27E1            ; Pattern Address? ??
        DB      $02
        DW      $2805            ; Pattern Address? ??
        DB      $00
        DW      $2847            ; Start of Pattern Table ??

L2850:  DB      $FF
        DW      $2740            ; Pattern Address? ??
        DB      $00
        DW      $2850            ; Start of Pattern Table ??

L2856:  DB      $02
        DW      $27E1            ; Pattern Address? ??
        DB      $02
        DW      $2805            ; Pattern Address? ??
        DB      $08
        DW      $2740            ; Pattern Address? ??
        DB      $00
        DW      $2856            ; Start of Pattern Table ??

L2862:  DW      $2850            ; Start of a Pattern Table ??
        DW      $2847            ; Start of a Pattern Table ??
        DW      $2856            ; Start of a Pattern Table ??

L2868:  DB      $04,$02            ; Pattern Address? ??
        DB      $02,$05            ; Pattern Size ??
        DB      $00,$00            ; . . . . . . . .
        DB      $3C,$00            ; . 3 3 . . . . .
        DB      $F5,$55            ; 3 3 1 1 1 1 1 1
        DB      $3C,$00            ; . 3 3 . . . . .
        DB      $00,$00            ; . . . . . . . .

L2876:  DB      $04,$07            ; Pattern Address? ??
        DB      $03,$0A            ; Pattern Size ??
        DB      $00,$00,$80        ; . . . . . . . . 2 . . .
        DB      $00,$02,$00        ; . . . . . . . 2 . . . .
        DB      $00,$08,$00        ; . . . . . . 2 . . . . .
        DB      $00,$20,$80        ; . . . . . 2 . . 2 . . .
        DB      $00,$82,$00        ; . . . . 2 . . 2 . . . .
        DB      $02,$08,$00        ; . . . 2 . . 2 . . . . .
        DB      $3C,$20,$C0        ; . 3 3 . . 2 . . 3 . . .
        DB      $C7,$5D,$00        ; 3 . 1 3 1 1 3 1 . . . .
        DB      $3C,$00,$00        ; . 3 3 . . . . . . . . .
        DB      $00,$00,$00        ; . . . . . . . . . . . .

L2898:  DB      $04,$02            ; Pattern Address? ??
        DB      $03,$0A            ; Pattern Size? ??
        DB      $00,$00,$00        ; . . . . . . . . . . . .
        DB      $3C,$00,$00        ; . 3 3 . . . . . . . . .
        DB      $F5,$96,$00        ; 3 3 1 1 2 1 1 2 . . . .
        DB      $3C,$20,$C0        ; . 3 3 . . 2 . . 3 . . .
        DB      $02,$08,$00        ; . . . 2 . . 2 . . . . .
        DB      $00,$82,$00        ; . . . . 2 . . 2 . . . .
        DB      $00,$20,$80        ; . . . . . 2 . . 2 . . .
        DB      $00,$08,$00        ; . . . . . . 2 . . . . .
        DB      $00,$02,$00        ; . . . . . . . 2 . . . .
        DB      $00,$00,$80        ; . . . . . . . . 2 . . .

L28BA:  DB      $02
        DW      $2868            ; Pattern Address? ??
        DB      $03
        DW      $2876            ; Pattern Address? ??
        DB      $02
        DW      $2868            ; Pattern Address? ??
        DB      $03
        DW      $2898            ; Pattern Address? ??
        DB      $00
        DW      $28BA            ; Start of Pattern Table ??

;  Next 7 bytes moved using MOVE block transfer routine
L28C9:  DB      $20
        DB      $01
        DB      $20
        DB      $2F
        DB      $01
        DB      $02
        DB      $17

;  Next 7 bytes moved using MOVE block transfer routine
L28D0:  DB      $00
        DB      $01
        DB      $00
        DB      $10
        DB      $01
        DB      $07
        DB      $10

L28D7:  DB      $00
        DB      $2E
        DB      $59
        DB      $85
        DB      $00
        DB      $3F
        DB      $FF
        DB      $20
        DB      $60
        DB      $00

L28E1:  CALL    L210E
        CALL    L211D
        SYSSUK  MOVE             ;  UPI MOVE block transfer
        DW      $4F94            ;  ... Destination Address = 20372
        DW      $0007            ;  ... Byte Count = 7
        DW      $28D0            ;  ... Source Address = 10448
        ;
        SYSSUK  MOVE             ;  UPI MOVE block transfer
        DW      $4F8D            ;  ... Destination Address = 20365
        DW      $0007            ;  ... Byte Count = 7
        DW      $28C9            ;  ... Source Address = 10441
        ;
        LD      HL,L28D7
L28FA:  LD      BC,$080F
L28FD:  INC     C
        OUTI    
        JR      NZ,L28FD
L2902:  XOR     A
        LD      ($4F9D),A
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        LD      ($4F9B),DE
        LD      A,$01
        LD      ($4F9D),A
        RET     
        
L2913:  DB      $10
        DB      $05
        DB      $10
        DB      $30
        DB      $01
        DB      $03
        DB      $17
        DB      $10
        DB      $2E
        DB      $43
        DB      $70
        DB      $00
        DB      $3C
        DB      $AA
        DB      $10
        DB      $18
        DB      $00
        DB      $CD
        DB      $DF
        DB      $20
        DB      $FF
        DB      $5F
        DB      $8D
        DB      $4F
        DB      $07
        DB      $00
        DB      $13
        DB      $29
        DB      $21
        DB      $1A
        DB      $29
        DB      $C3
        DB      $FA
        DB      $28

;  Next 7 bytes moved using MOVE block transfer routine
L2935:  DB      $20
        DB      $FC
        DB      $20
        DB      $80
        DB      $01
        DB      $02
        DB      $10

L293C:  DB      $20
        DB      $18
        DB      $30
        DB      $48
        DB      $00
        DB      $36
        DB      $66
        DB      $18
        DB      $28
        DB      $00

L2946:  DB      $20
        DB      $08
        DB      $18
        DB      $10
        DB      $10
        DB      $28
        DB      $88
        DB      $38
        DB      $20
        DB      $00

L2950:  CALL    L20DF
        SYSSUK  MOVE             ;  UPI MOVE block transfer
        DW      $4F94            ;  ... Destination Address = 20372
        DW      $0007            ;  ... Byte Count = 7
        DW      L2935            ;  ... Source Address = 10549
        ;
        LD      HL,L293C
        JP      L28FA

L2961:  CALL    L20DF
        SYSSUK  MOVE             ;  UPI MOVE block transfer
        DW      $4F94            ;  ... Destination Address = 20372
        DW      $0007            ;  ... Byte Count = 7
        DW      L2935            ;  ... Source Address = 10549
        ;
        LD      A,$F8
        LD      ($4F95),A
        LD      HL,L2946
        JP      L28FA

L2977:  DB      $20
        DB      $2E
        DB      $80
        DB      $60
        DB      $00
        DB      $3A
        DB      $AA
        DB      $23
        DB      $03
        DB      $00

L2981   DB      $24
        DB      $60
        DB      $70
        DB      $80
        DB      $00
        DB      $13
        DB      $33
        DB      $26
        DB      $03
        DB      $00

L298B:  CALL    L2116
        LD      HL,L2977
        JP      L28FA
L2994:  CALL    L2116
        LD      HL,L2981
        JP      L28FA
        ;
L299D:  OR      A
        LD      HL,L298B
        JR      NZ,L29A6
        LD      HL,L2994
L29A6:  LD      ($4F9F),HL
        RET     

;  Next 7 bytes moved using MOVE block transfer routine
L29AA:  DB      $42
        DB      $01
        DB      $42
        DB      $50
        DB      $04
        DB      $04
        DB      $14

;  Next 7 bytes moved using MOVE block transfer routine
L29B1:  DB      $23
        DB      $23
        DB      $23
        DB      $43
        DB      $08
        DB      $08
        DB      $10

L29B8:  DB      $23
        DB      $2E
        DB      $46
        DB      $6A
        DB      $42
        DB      $28
        DB      $88
        DB      $40
        DB      $FF
        DB      $FF
        DB      $FF
        DB      $FF

L29C4:  CALL    L2116
        CALL    L211D
        SYSSUK  MOVE             ;  UPI MOVE block transfer
        DW      $4F94            ;  ... Destination Address = 20372
        DW      $0007            ;  ... Byte Count = 7
        DW      L29AA            ;  ... Source Address = 10666
        ;
        LD      HL,L29B8
        JP      L28FA

L29D8:  CALL    L210E
        CALL    L211D
        SYSSUK  MOVE             ;  UPI MOVE block transfer
        DW      $4F8D            ;  ... Destination Address = 20365
        DW      $0007            ;  ... Byte Count = 7
        DW      L29B1            ;  ... Source Address = 10673
        ;
        LD      HL,L29B8
        CALL    L28FA
        INC     HL
        JP      L2902
        ;
L29F0:  PUSH    AF
        CALL    L210E
        POP     AF
        CALL    L299D
        JP      (HL)

;  Next 7 bytes moved using MOVE block transfer routine
L29F9:  DB      $80
        DB      $08
        DB      $10
        DB      $80
        DB      $03
        DB      $03
        DB      $10

;  Next 7 bytes moved using MOVE block transfer routine
L2A00:  DB      $40
        DB      $08
        DB      $40
        DB      $78
        DB      $06
        DB      $06
        DB      $17

L2A07:  DB      $80
        DB      $40
        DB      $3E
        DB      $3C
        DB      $44
        DB      $2E
        DB      $EE
        DB      $20
        DB      $30
        DB      $00

L2A11:  CALL    L210E
        CALL    L211D
        LD      HL,L29C4
        LD      ($4F9F),HL
        SYSSUK  MOVE             ;  UPI MOVE block transfer
        DW      $4F94            ;  ... Destination Address = 20372
        DW      $0007            ;  ... Byte Count = 7
        DW      L29F9            ;  ... Source Address = 10745
        ;
        SYSSUK  MOVE             ;  UPI MOVE block transfer
        DW      $4F8D            ;  ... Destination Address = 20365
        DW      $0007            ;  ... Byte Count = 7
        DW      L2A00            ;  ... Source Address = 10752
        ;
        LD      HL,L2A07
        JP      L28FA

L2A33:  DB      $08
        DB      $01
        DB      $08
        DB      $18
        DB      $06
        DB      $06
        DB      $10
        DB      $08
        DB      $25
        DB      $28
        DB      $2B
        DB      $06
        DB      $2F
        DB      $FF
        DB      $00
        DB      $60
        DB      $00
        DB      $CD
        DB      $E8
        DB      $20
        DB      $CD
        DB      $1D
        DB      $21
        DB      $FF
        DB      $5F
        DB      $94
        DB      $4F
        DB      $07
        DB      $00
        DB      $33
        DB      $2A
        DB      $21
        DB      $3A
        DB      $2A
        DB      $C3
        DB      $FA
        DB      $28
        DB      $CD
        DB      $44
        DB      $2A
        DB      $3E
        DB      $19
        DB      $D3
        DB      $17
        DB      $3E
        DB      $3F
        DB      $D3
        DB      $15
        DB      $C9
        DB      $C1
        DB      $41
        DB      $A2
        DB      $41
        DB      $83
        DB      $41
        DB      $64
        DB      $41
        DB      $45
        DB      $41
        DB      $26
        DB      $41
        DB      $07
        DB      $41
        DB      $42
        DB      $40
        DB      $21
        DB      $40
        DB      $E8
        DB      $40
        DB      $C9
        DB      $40
        DB      $B8
        DB      $40
        DB      $A7
        DB      $40
        DB      $96
        DB      $40
        DB      $0A
        DB      $95
        DB      $13
        DB      $46
;  Data Used in Move Block Transfer of 4 bytes 
L2A84:  DB      $28
        DB      $3C
        DB      $11
        DB      $48

L2A88:  PUSH    DE
        LD      IY,$4FC5
        CALL    L2053
        LD      HL,$4FC5
        POP     DE
        RET     

L2A95:  PUSH    DE
        LD      DE,($4F1F)
        LD      D,$00
        ADD     HL,DE
        POP     DE
        RET     

L2A9f:  LD      HL,$4F19
        JR      L2A95
L2AA4:  LD      HL,$4F11
        JR      L2A95
L2AA9:  LD      HL,$4F0D
        JR      L2A95

L2AAE:  LD      HL,$4F09
        JR      L2A95
L2AB3:  LD      HL,$4F15
        JR      L2A95
L2AB8:  LD      HL,$4F05
        JP      L2A95
L2ABE:  LD      HL,$4EFD
        JP      L2A95
L2AC4:  LD      HL,$4EF9
        JP      L2A95
L2ACA:  LD      HL,$4F01
        JP      L2A95
L2AD0:  LD      A,($4F1F)
        ADD     A,$10
        LD      C,A
        RET     

L2AD7:  LD      A,($4F1F)
        SLA     A
        LD      E,A
        LD      D,$00
        LD      HL,$4FA2
        ADD     HL,DE
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        DEC     HL
        EX      DE,HL
        RET     

L2AE9:  LD      L,(HL)
        LD      H,$00
        CALL    L2A88
        LD      BC,$C20E
L2AF2:  LD      D,$53
L2AF4:  LD      IX,$020D
L2AF8:  CALL    L2081
        SYSTEM  DISNUM           ;  UPI DISplay NUMber
        ;
        CALL    L208E
        RET     

L2B01:  LD      E,$99
        LD      BC,$C124
        CALL    L2AAE
        JR      L2AF2
L2B0B:  SYSSUK  FILL             ;  UPI FILL memory with data
        DW      $41E1            ;  ... Memory Address = 16865
        DW      $09D7            ;  ... Byte Count = 2519
        DB      $00              ;  ... Data = 0
        ;
        RET     

L2B13:  SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $00              ;  ... X = 0
        DB      $50              ;  ... Y = 80
        DB      $A0              ;  ... Width = 160
        DB      $0B              ;  ... Height = 11
        DB      $FF              ;  ... Color = 255
        ;
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $01              ;  ... X = 1
        DB      $51              ;  ... Y = 81
        DB      $9E              ;  ... Width = 158
        DB      $09              ;  ... Height = 9
        DB      $00              ;  ... Color = 0
        ;
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $32              ;  ... X = 50
        DB      $50              ;  ... Y = 80
        DB      $01              ;  ... Width = 1
        DB      $0A              ;  ... Height = 10
        DB      $FF              ;  ... Color = 255
        ;
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $70              ;  ... X = 112
        DB      $51              ;  ... Y = 81
        DB      $2F              ;  ... Width = 47
        DB      $09              ;  ... Height = 9
        DB      $AA              ;  ... Color = 170
        ;
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $33              ;  ... X = 51
        DB      $51              ;  ... Y = 81
        DB      $3C              ;  ... Width = 60
        DB      $09              ;  ... Height = 9
        DB      $55              ;  ... Color = 85
        ;
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $6F              ;  ... X = 111
        DB      $50              ;  ... Y = 80
        DB      $01              ;  ... Width = 1
        DB      $0A              ;  ... Height = 10
        DB      $FF              ;  ... Color = 255
        ;
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $46              ;  ... X = 70
        DB      $52              ;  ... Y = 82
        DB      $14              ;  ... Width = 20
        DB      $07              ;  ... Height = 7
        DB      $FF              ;  ... Color = 255
        ;
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $47              ;  ... X = 71
        DB      $53              ;  ... Y = 83
        DB      $12              ;  ... Width = 18
        DB      $05              ;  ... Height = 5
        DB      $55              ;  ... Color = 85
        ;
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $49              ;  ... X = 73
        DB      $52              ;  ... Y = 82
        DB      $0E              ;  ... Width = 14
        DB      $07              ;  ... Height = 7
        DB      $55              ;  ... Color = 85
        ;
        SYSSUK  CHRDIS           ;  UPI CHaRacter DISplay
        DB      $72              ;  ... X = 114
        DB      $52              ;  ... Y = 82
        DB      $2C              ;  ... Options = 44
        DB      $46              ;  ... Character = 70
        ;
        SYSSUK  CHRDIS           ;  UPI CHaRacter DISplay
        DB      $84              ;  ... X = 132
        DB      $52              ;  ... Y = 82
        DB      $2C              ;  ... Options = 44
        DB      $53              ;  ... Character = 83
        ;
        XOR     A
        OUT     ($0C),A
        LD      A,$EE
        LD      ($0CC8),A
        LD      ($0E08),A
        LD      ($0CCD),A
        LD      ($0E0D),A
        LD      A,$BA
        LD      ($0DE0),A
        LD      ($0CF0),A
        LD      ($0DE5),A
        LD      ($0CF5),A
        RET     
        
L2B7E:  CALL    L2AD7
        CALL    L2A88
        LD      E,$07
        LD      BC,$850C
        LD      D,$52
        CALL    L2AF8
        CALL    L2AB3
        LD      E,$8C
        CALL    L2AE9
        CALL    L2AB8
        LD      E,$78
        JP      L2AE9
        
L2B9E:  LD      HL,$4FA1
        XOR     A
        CP      (HL)
        LD      (HL),A
        CALL    NZ,L2B7E
        LD      DE,$0505
        CALL    L20CB
        JP      L2B9E
        
L2BB0:  DB      $09
L2BB1:  DB      "GAME OVER",$00
L2BBB:  DB      $0D
L2BBC:  DB      "COSMIC RAIDER",$00
L2BCA:  DB      $10
L2BCB:  DB      "ENTERING SECTOR ",$00
L2BDC:  DB      $06
L2BDD:  DB      "SECTOR",$00
L2BE4:  DB      $15
L2BE5:  DB      "INTENSITY      0 TO 9",$00
L2BFB:  DB      $0A
L2BFC:  DB      "# OF SHIPS",$00
L2C07:  DB      $08
L2C08:  DB      "PLAYER 1",$00
L2C11:  DB      $08
L2C12:  DB      "PLAYER 2",$00
L2C1B:  DB      $08
L2C1C:  DB      "PLAYER 3",$00
L2C25:  DB      $08
L2C26:  DB      "PLAYER 4",$00
L2C2F:  DB      $05
L2C30:  DB      "BONUS",$00
L2C36:  DB      $09
L2C37:  DB      "GOOD LUCK",$00
L2C41:  DB      $08
        DB      $2C
        DB      $12
        DB      $2C
        DB      $1C
        DB      $2C
        DB      $26
        DB      $2C
L2C49:  CALL    L2A9F
        LD      A,(HL)
        LD      L,A
        LD      H,$00
        CALL    L2A88
        SYSSUK  STRDIS           ;  UPI STRing DISplay
        DB      $0C              ;  ... X = 12
        DB      $10              ;  ... Y = 16
        DB      00001000B        ;  ... Options - ON Color $10
        DW      L2BCB            ;  ... String Address "ENTERING SECTOR "
        ;
        DEC     E
        DEC     E
        DEC     E
        DEC     E
        LD      BC,$8208
        LD      HL,$4FC5
        JP      L2AF8
        ;
L2C67:  LD      C,00100100B      ;  ... Options - XOR Write, ON Color $01
        LD      HL,L2BB1         ;  ... String Address "GAME OVER"
L2C6C:  SYSTEM  STRDIS           ;  UPI STRing DISplay
        ;
        RET     

L2C6F:  LD      A,$06
        ADD     A,E
        LD      E,A
        LD      C,$2C
        LD      HL,$2C30
        SYSTEM  STRDIS           ;  UPI STRing DISplay
        ;
        RET     

L2C7B:  LD      D,$0D
        LD      A,$20
        LD      HL,L2574
        SYSTEM  WRITR            ;  UPI WRITe RELATIVE
        ;
        CALL    L2AB3
        INC     (HL)
        RET     

L2C89:  PUSH    DE
        LD      A,($4F1F)
        LD      HL,$2C41
        SYSTEM  INDEXW           ;  UPI INDEX Word by A
        ;
        EX      DE,HL
        POP     DE
        LD      D,$10
        LD      C,$2C
        SYSTEM  STRDIS           ;  UPI STRing DISplay
        ;
        RET     
        
L2C9B:  PUSH    BC
        LD      E,$04
        CALL    L2C89
        CALL    L2C6F
        SYSSUK  WRITR            ;  UPI WRITe RELATIVE
        DB      116              ;  ... X Coordinate 
        DB      17               ;  ... Y Coordinate
        DB      $20              ;  ... Magic Register for X-OR
        DW      L2740            ;  ... Pattern Address - Player's Ship
        ;
        POP     BC
        PUSH    BC
        LD      A,B
        OR      A
        JR      Z,L2CB6
        LD      E,$82
        CALL    L2C7B
L2CB6:  POP     BC
        LD      A,B
        CP      $02
        JR      NZ,L2CC1
        LD      E,$8D
        CALL    L2C7B
L2CC1:  CALL    L2AAE
        INC     (HL)
        JP      L2B01

L2CC8:  PUSH    BC
        LD      E,$04
        CALL    L2C89
        CALL    L2C6F
        LD      E,$74
        CALL    L2C7B
        POP     BC
        PUSH    BC
        LD      A,B
        CP      $02
        JR      C,L2CE2
        LD      E,$80
        CALL    L2C7B
L2CE2:  POP     BC
        LD      A,B
        CP      $03
        JR      NZ,L2CED
        LD      E,$8C
        CALL    L2C7B
L2CED:  JP      L2B7E

L2CF0:  LD      E,$0C
        CALL    L2C89
        INC     E
        INC     E
        INC     E
        INC     E
        INC     E
        LD      C,$2C
        LD      HL,L2C37
        SYSTEM  STRDIS           ;  UPI STRing DISplay
        ;
        RET     

L2D02:  LD      E,$0C
        CALL    L2C89
        INC     E
        INC     E
        INC     E
        INC     E
        INC     E
        JP      L2C67
        
L2D0F:  LD      DE,$1030
        JP      L2C67
        
L2D15:  LD      H,(IX+$20)
        LD      L,(IX+$1F)
        LD      E,(IX+$06)
        DEC     E
        DEC     E
        DEC     E
        DEC     E
        DEC     E
        DEC     E
        LD      D,(IX+$0B)
        DEC     D
        DEC     D
        DEC     D
        DEC     D
        CALL    L2A88
        LD      BC,$C42C
        PUSH    IX
        CALL    L2AF4
        POP     IX
        RET

L2D39:  LD      A,($4F1F)
        INC     A
        LD      B,A
        LD      C,$0C
        LD      A,$0F
L2D42:  ADD     A,C
        DJNZ    L2D42
        LD      D,A              ;  ... Y = 
        LD      E,$0A            ;  ... X = 10
        LD      BC,$0908         ;  ... Y-Size, X-Size
        LD      A,$55            ;  ... Color = 255  
        SYSTEM  RECTAN           ;  UPI paint a RECTANgle
        ;
L2D4F:  LD      A,($4F1F)
        PUSH    AF
        XOR     A
        LD      ($4F1F),A
        LD      A,($4FF3)
        LD      B,A
        LD      D,$10
L2D5D:  PUSH    BC
        LD      A,$0C
        LD      E,A              
        ADD     A,D
        LD      D,A              ;  ... DE = Standard Y, X coordinates
        LD      C,00100100B      ;  ... Options - XOR Write, ON Color $01
        LD      A,($4F1F)
        ADD     A,$31            ;  ... ASCII Character to Display
        SYSTEM  CHRDIS           ;  UPI CHaRacter DISplay
        ;
        PUSH    DE
        CALL    L2AD7
        POP     DE
        CALL    L2A88
        INC     D
        INC     E
        INC     E
        INC     E
        LD      BC,$C52C
        CALL    L2AF4
        CALL    L2A9F
        LD      A,(HL)
        OR      A
        JR      NZ,L2D87
        LD      A,$01
L2D87:  LD      H,$00
        LD      L,A
        CALL    L2A88
        DEC     D                ;  ... Standard Coordinates
        LD      A,$08
        ADD     A,E
        LD      E,A              ;  ... Standard Coordinates
        LD      C,00100100B      ;  ... Options - XOR Write, ON Color $01
        LD      HL,$2BDD         ;  ... String Address "SECTOR"
        SYSTEM  STRDIS           ;  UPI STRing DISplay
        ;
        INC     E
        INC     E
        INC     E
        LD      HL,$4FC5
        LD      BC,$822C
        CALL    L2AF8
        PUSH    DE
        LD      A,$03
        ADD     A,E
        LD      E,A              ;  ... X Coordinate
        LD      A,$20            ;  ... Magic Register for X-OR
        LD      HL,L2740         ;  ... Pattern Address - Player's Ship
        SYSTEM  WRITR            ;  UPI WRITe RELATIVE
        ;
        POP     DE
        LD      A,$1D
        ADD     A,E
        LD      E,A
        CALL    L2AAE
        LD      BC,$012C
        CALL    L2AF8
        LD      HL,$4F1F
        INC     (HL)
        POP     BC
        DJNZ    L2D5D
        POP     AF
        LD      ($4F1F),A
        RET     

L2DCB:  LD      H,(IX+$03)
        LD      L,(IX+$02)
        LD      D,(IX+$01)
        LD      E,(IX+$00)
L2DD7:  ADD     HL,DE
        ADD     HL,BC
        DEC     A
        JR      NZ,L2DD7
        RES     3,(IX+$04)
        BIT     0,(IX+$04)
        JR      Z,L2E1F
        LD      A,H
        LD      B,(IY+$00)
        CP      $CF
        JR      NC,L2E05
        BIT     4,(IX+$04)
        JR      Z,L2DFA
        EX      AF,AF'
        LD      A,$05
        ADD     A,B
        LD      B,A
        EX      AF,AF'
L2DFA:  CP      B
        JR      C,L2E05
        LD      B,(IY+$01)
        CP      B
        JR      C,L2E1F
        JR      Z,L2E1F
L2E05:  SET     3,(IX+$04)
        LD      H,B
        LD      L,$00
        BIT     1,(IX+$04)
        JR      Z,L2E1F
        LD      A,D
        CPL     
        LD      D,A
        LD      A,E
        CPL     
        LD      E,A
        INC     DE
        LD      (IX+$00),E
        LD      (IX+$01),D
L2E1F:  LD      (IX+$02),L
        LD      (IX+$03),H
        RET     

L2E26:  OR      A
        RET     Z
        PUSH    HL
        POP     IY
        LD      BC,($4F26)
        PUSH    IX
        PUSH    AF
        LD      DE,$0003
        ADD     IX,DE
        CALL    L2DCB
        POP     AF
        LD      DE,$0005
        ADD     IX,DE
        INC     IY
        INC     IY
        LD      BC,$0000
        CALL    L2DCB
        POP     IX
        RET     
        
L2E4D:  LD      HL,L20C7-128
        LD      (USERTB),HL      ; USER Table Base + routine = JumP address
        LD      HL,L20C9-64
        LD      (UMARGT),HL      ; User Mask ARGument Table + (routine / 2)
L2E59:  LD      HL,L2E59
        PUSH    HL
        EI      
        SYSSUK  $80              ;  User MACRO routine 00 ($20C7)
        DB      $14              ;  ... User Argument 1 (E Register) 
        DB      $02              ;  ... User Argument 2 (D Register)
        ;
        SYSSUK  DOIT             ;  UPI DOIT table, branch to translation handler
        DW      L21C5            ;  ... Do Table Address = 8645
        RET
             
L2E67:  PUSH    DE
        PUSH    IY
        POP     DE
        LD      BC,$0011
        LDIR    
        LD      D,(IX+$06)
        ADD     A,D
        LD      (IY+$06),A
        LD      D,(IX+$0B)
        LD      A,(IY+$0B)
        ADD     A,D
        LD      (IY+$0B),A
        POP     DE
        LD      (IY+$03),E
        LD      (IY+$04),D
        PUSH    IX
        PUSH    IY
        POP     IX
        CALL    L2497
        POP     IX
        RET     

L2E94:  DB      $04
        DB      $96
        DB      $64
        DB      $2A
        DB      $09
        DB      $20
        DB      $FF
        DB      $FF
        DB      $00
        DB      $00
        DB      $00
        DB      $00
        DB      $05
        DB      $00
        DB      $00
        DB      $00
        DB      $01
        DB      $40
        DB      $00
        DB      $00
        DB      $96
        DB      $2E
        DB      $21
        DB      $96
        DB      $40
        DB      $11
        DB      $11
        DB      $00
        DB      $23
        DB      $23
        DB      $7E
        DB      $B7
        DB      $28
        DB      $09
        DB      $19
        DB      $7E
        DB      $B7
        DB      $28
        DB      $04
        DB      $19
        DB      $7E
        DB      $B7
        DB      $C0
        DB      $2B
        DB      $2B
        DB      $E5
        DB      $FD
        DB      $E1
        DB      $3A
        DB      $DC
        DB      $40
        DB      $CB
        DB      $47
        DB      $3E
        DB      $08
        DB      $20
        DB      $05
        DB      $11
        DB      $40
        DB      $04
        DB      $18
        DB      $05
        DB      $11
        DB      $C0
        DB      $FB
        DB      $ED
        DB      $44
        DB      $21
        DB      $99
        DB      $2E
        DB      $CD
        DB      $67
        DB      $2E
        DB      $C3
        DB      $50
        DB      $29
        DB      $04
        DB      $96
        DB      $78
        DB      $2A
        DB      $01
        DB      $20
        DB      $FF
        DB      $FF
        DB      $00
        DB      $00
        DB      $00
        DB      $00
        DB      $05
        DB      $00
        DB      $00
        DB      $00
        DB      $00
        DB      $40
        DB      $00
        DB      $00
        DB      $E2
        DB      $2E
        DB      $21
        DB      $63
        DB      $40
        DB      $11
        DB      $11
        DB      $00
        DB      $23
        DB      $23
        DB      $7E
        DB      $B7
        DB      $28
        DB      $09
        DB      $19
        DB      $7E
        DB      $B7
        DB      $28
        DB      $04
        DB      $19
        DB      $7E
        DB      $B7
        DB      $C0
        DB      $2B
        DB      $2B
        DB      $E5
        DB      $FD
        DB      $E1
        DB      $3A
        DB      $CF
        DB      $40
        DB      $DD
        DB      $96
        DB      $06
        DB      $3E
        DB      $0B
        DB      $38
        DB      $05
        DB      $11
        DB      $00
        DB      $04
        DB      $18
        DB      $05
        DB      $11
        DB      $00
        DB      $FC
        DB      $ED
        DB      $44
        DB      $21
        DB      $E5
        DB      $2E
        DB      $CD
        DB      $67
        DB      $2E
        DB      $C3
        DB      $61
        DB      $29
        DB      $DD
        DB      $5E
        DB      $06
        DB      $DD
        DB      $7E
        DB      $0B
        DB      $16
        DB      $00
        DB      $21
        DB      $00
        DB      $00
        DB      $06
        DB      $00
        DB      $E6
        DB      $F8
        DB      $4F
        DB      $09
        DB      $09
        DB      $09
        DB      $09
        DB      $09
        DB      $CB
        DB      $3B
        DB      $CB
        DB      $3B
        DB      $CB
        DB      $3B
        DB      $3E
        DB      $FE
        DB      $83
        DB      $FE
        DB      $F0
        DB      $38
        DB      $01
        DB      $AF
        DB      $5F
        DB      $4B
        DB      $CB
        DB      $3B
        DB      $CB
        DB      $3B
        DB      $19
        DB      $DD
        DB      $7E
        DB      $1C
        DB      $E6
        DB      $FC
        DB      $47
        DB      $79
        DB      $E6
        DB      $03
        DB      $B0
        DB      $DD
        DB      $77
        DB      $1C
        DB      $DD
        DB      $46
        DB      $1B
        DB      $16
        DB      $05
        DB      $AF
        DB      $82
        DB      $10
        DB      $FD
        DB      $C6
        DB      $08
        DB      $85
        DB      $6F
        DB      $3E
        DB      $00
        DB      $8C
        DB      $67
        DB      $11
        DB      $80
        DB      $0C
        DB      $19
        DB      $DD
        DB      $75
        DB      $1D
        DB      $DD
        DB      $74
        DB      $1E
        DB      $C9
        DB      $DD
        DB      $6E
        DB      $1D
        DB      $DD
        DB      $66
        DB      $1E
        DB      $DD
        DB      $7E
        DB      $1C
        DB      $4F
        DB      $E6
        DB      $03
        DB      $CB
        DB      $EF
        DB      $D3
        DB      $0C
        DB      $79
        DB      $E6
        DB      $C0
        DB      $77
        DB      $C9
        DB      $DD
        DB      $35
        DB      $1A
        DB      $C0
        DB      $DD
        DB      $36
        DB      $1A
        DB      $04
        DB      $CD
        DB      $80
        DB      $2F
        DB      $CD
        DB      $2D
        DB      $2F
        DB      $C3
        DB      $80
        DB      $2F
        DB      $AF
        DB      $DD
        DB      $CB
        DB      $07
        DB      $56
        DB      $C8
        DB      $DD
        DB      $CB
        DB      $07
        DB      $66
        DB      $C0
        DB      $DD
        DB      $6E
        DB      $0F
        DB      $DD
        DB      $66
        DB      $10
        DB      $11
        DB      $00
        DB      $00
        DB      $19
        DB      $5E
        DB      $23
        DB      $56
        DB      $23
        DB      $46
        DB      $EB
        DB      $5E
        DB      $23
        DB      $56
        DB      $D5
        DB      $FD
        DB      $E1
        DB      $D9
        DB      $DD
        DB      $CB
        DB      $0C
        DB      $76
        DB      $28
        DB      $05
        DB      $01
        DB      $01
        DB      $03
        DB      $18
        DB      $19
        DB      $DD
        DB      $CB
        DB      $0C
        DB      $66
        DB      $28
        DB      $05
        DB      $01
        DB      $02
        DB      $04
        DB      $18
        DB      $0E
        DB      $DD
        DB      $66
        DB      $12
        DB      $DD
        DB      $6E
        DB      $11
        DB      $23
        DB      $23
        DB      $7E
        DB      $CB
        DB      $27
        DB      $47
        DB      $23
        DB      $4E
        DB      $DD
        DB      $66
        DB      $06
        DB      $DD
        DB      $6E
        DB      $0B
        DB      $D9
        DB      $D9
        DB      $FD
        DB      $CB
        DB      $07
        DB      $66
        DB      $20
        DB      $6A
        DB      $FD
        DB      $CB
        DB      $01
        DB      $7E
        DB      $28
        DB      $64
        DB      $FD
        DB      $CB
        DB      $0C
        DB      $76
        DB      $28
        DB      $0B
        DB      $FD
        DB      $7E
        DB      $02
        DB      $B7
        DB      $28
        DB      $58
        DB      $11
        DB      $01
        DB      $03
        DB      $18
        DB      $22
        DB      $FD
        DB      $CB
        DB      $0C
        DB      $66
        DB      $28
        DB      $05
        DB      $11
        DB      $02
        DB      $04
        DB      $18
        DB      $17
        DB      $FD
        DB      $7E
        DB      $1B
        DB      $FE
        DB      $02
        DB      $20
        DB      $41
        DB      $E5
        DB      $FD
        DB      $66
        DB      $12
        DB      $FD
        DB      $6E
        DB      $11
        DB      $23
        DB      $23
        DB      $7E
        DB      $CB
        DB      $27
        DB      $57
        DB      $23
        DB      $5E
        DB      $E1
        DB      $FD
        DB      $7E
        DB      $06
        DB      $08
        DB      $FD
        DB      $7E
        DB      $0B
        DB      $EB
        DB      $09
        DB      $EB
        DB      $1C
        DB      $CB
        DB      $2B
        DB      $95
        DB      $FA
        DB      $4B
        DB      $30
        DB      $BB
        DB      $D2
        DB      $64
        DB      $30
        DB      $C3
        DB      $4F
        DB      $30
        DB      $83
        DB      $FA
        DB      $64
        DB      $30
        DB      $08
        DB      $94
        DB      $FA
        DB      $5B
        DB      $30
        DB      $BA
        DB      $D2
        DB      $64
        DB      $30
        DB      $C3
        DB      $5F
        DB      $30
        DB      $82
        DB      $FA
        DB      $64
        DB      $30
        DB      $3E
        DB      $01
        DB      $A7
        DB      $18
        DB      $01
        DB      $AF
        DB      $D9
        DB      $28
        DB      $1A
        DB      $DD
        DB      $CB
        DB      $0C
        DB      $6E
        DB      $28
        DB      $04
        DB      $FD
        DB      $CB
        DB      $13
        DB      $D6
        DB      $FD
        DB      $CB
        DB      $0C
        DB      $6E
        DB      $28
        DB      $04
        DB      $DD
        DB      $CB
        DB      $13
        DB      $D6
        DB      $FD
        DB      $CB
        DB      $07
        DB      $EE
        DB      $06
        DB      $01
        DB      $23
        DB      $5E
        DB      $23
        DB      $56
        DB      $D5
        DB      $FD
        DB      $E1
        DB      $05
        DB      $C2
        DB      $F3
        DB      $2F
        DB      $C9
        DB      $AF
        DB      $DD
        DB      $BE
        DB      $02
        DB      $C8
        DB      $CD
        DB      $BD
        DB      $24
        DB      $DD
        DB      $35
        DB      $02
        DB      $C8
        DB      $DD
        DB      $CB
        DB      $07
        DB      $6E
        DB      $28
        DB      $05
        DB      $AF
        DB      $DD
        DB      $77
        DB      $02
        DB      $C9
        DB      $3E
        DB      $01
        DB      $01
        DB      $00
        DB      $00
        DB      $CD
        DB      $2F
        DB      $2E
        DB      $CD
        DB      $97
        DB      $24
        DB      $B7
        DB      $28
        DB      $0A
        DB      $CD
        DB      $A6
        DB      $2F
        DB      $B7
        DB      $28
        DB      $04
        DB      $DD
        DB      $36
        DB      $02
        DB      $01
        DB      $DD
        DB      $CB
        DB      $07
        DB      $5E
        DB      $28
        DB      $06
        DB      $DD
        DB      $36
        DB      $02
        DB      $01
        DB      $18
        DB      $0A
        DB      $DD
        DB      $CB
        DB      $0C
        DB      $5E
        DB      $28
        DB      $04
        DB      $DD
        DB      $36
        DB      $02
        DB      $01
        DB      $C9
        DB      $DD
        DB      $7E
        DB      $18
        DB      $FE
        DB      $FF
        DB      $C8
        DB      $DD
        DB      $CB
        DB      $07
        DB      $66
        DB      $28
        DB      $10
        DB      $DD
        DB      $6E
        DB      $0F
        DB      $DD
        DB      $66
        DB      $10
        DB      $11
        DB      $09
        DB      $00
        DB      $19
        DB      $5E
        DB      $23
        DB      $56
        DB      $EB
        DB      $18
        DB      $1E
        DB      $DD
        DB      $CB
        DB      $0C
        DB      $66
        DB      $28
        DB      $0A
        DB      $3A
        DB      $20
        DB      $4F
        DB      $6F
        DB      $3A
        DB      $21
        DB      $4F
        DB      $67
        DB      $18
        DB      $0E
        DB      $DD
        DB      $6E
        DB      $0F
        DB      $DD
        DB      $66
        DB      $10
        DB      $11
        DB      $05
        DB      $00
        DB      $19
        DB      $5E
        DB      $23
        DB      $56
        DB      $EB
        DB      $DD
        DB      $35
        DB      $18
        DB      $C0
        DB      $E5
        DB      $DD
        DB      $7E
        DB      $17
        DB      $3C
        DB      $28
        DB      $07
        DB      $11
        DB      $03
        DB      $00
        DB      $47
        DB      $19
        DB      $10
        DB      $FD
        DB      $47
        DB      $7E
        DB      $D1
        DB      $B7
        DB      $20
        DB      $04
        DB      $EB
        DB      $7E
        DB      $06
        DB      $00
        DB      $DD
        DB      $77
        DB      $18
        DB      $23
        DB      $7E
        DB      $DD
        DB      $77
        DB      $11
        DB      $23
        DB      $7E
        DB      $DD
        DB      $77
        DB      $12
        DB      $DD
        DB      $70
        DB      $17
        DB      $C9
        DB      $3A
        DB      $78
        DB      $4F
        DB      $FE
        DB      $00
        DB      $C2
        DB      $B1
        DB      $23
        DB      $3E
        DB      $01
        DB      $32
        DB      $78
        DB      $4F
        DB      $AF
        DB      $32
        DB      $72
        DB      $4F
        DB      $3A
        DB      $75
        DB      $4F
        DB      $32
        DB      $73
        DB      $4F
        DB      $FB
        DB      $3A
        DB      $78
        DB      $4F
        DB      $FE
        DB      $01
        DB      $C2
        DB      $80
        DB      $31
        DB      $3A
        DB      $72
        DB      $4F
        DB      $B7
        DB      $C2
        DB      $80
        DB      $31
        DB      $3A
        DB      $73
        DB      $4F
        DB      $B7
        DB      $CA
        DB      $80
        DB      $31
        DB      $21
        DB      $80
        DB      $22
        DB      $CD
        DB      $36
        DB      $22
        DB      $7D
        DB      $B4
        DB      $20
        DB      $0D
        DB      $21
        DB      $75
        DB      $4F
        DB      $35
        DB      $21
        DB      $73
        DB      $4F
        DB      $35
        DB      $CD
        DB      $D7
        DB      $22
        DB      $18
        DB      $D3
        DB      $3E
        DB      $00
        DB      $32
        DB      $78
        DB      $4F
        DB      $C3
        DB      $B1
        DB      $23
        DB      $DD
        DB      $CB
        DB      $07
        DB      $66
        DB      $28
        DB      $2F
        DB      $DD
        DB      $46
        DB      $02
        DB      $DD
        DB      $35
        DB      $19
        DB      $20
        DB      $24
        DB      $DD
        DB      $CB
        DB      $01
        DB      $BE
        DB      $DD
        DB      $CB
        DB      $13
        DB      $76
        DB      $28
        DB      $03
        DB      $CD
        DB      $15
        DB      $2D
        DB      $CD
        DB      $80
        DB      $2F
        DB      $F1
        DB      $21
        DB      $25
        DB      $4F
        DB      $35
        DB      $DD
        DB      $CB
        DB      $0C
        DB      $66
        DB      $28
        DB      $08
        DB      $3E
        DB      $01
        DB      $32
        DB      $24
        DB      $4F
        DB      $C3
        DB      $3B
        DB      $31
        DB      $C9
        DB      $10
        DB      $D5
        DB      $C9
        DB      $DD
        DB      $CB
        DB      $07
        DB      $6E
        DB      $C8
        DB      $DD
        DB      $CB
        DB      $0C
        DB      $66
        DB      $28
        DB      $30
        DB      $DD
        DB      $CB
        DB      $07
        DB      $AE
        DB      $DD
        DB      $CB
        DB      $13
        DB      $56
        DB      $28
        DB      $11
        DB      $CD
        DB      $11
        DB      $2A
        DB      $3A
        DB      $22
        DB      $4F
        DB      $32
        DB      $23
        DB      $4F
        DB      $DD
        DB      $CB
        DB      $13
        DB      $DE
        DB      $DD
        DB      $CB
        DB      $13
        DB      $96
        DB      $3A
        DB      $23
        DB      $4F
        DB      $B7
        DB      $C0
        DB      $CD
        DB      $E1
        DB      $28
        DB      $3E
        DB      $01
        DB      $32
        DB      $1E
        DB      $4F
        DB      $DD
        DB      $36
        DB      $09
        DB      $01
        DB      $DD
        DB      $36
        DB      $08
        DB      $00
        DB      $DD
        DB      $CB
        DB      $07
        DB      $E6
        DB      $DD
        DB      $CB
        DB      $0C
        DB      $8E
        DB      $DD
        DB      $36
        DB      $17
        DB      $00
        DB      $DD
        DB      $36
        DB      $18
        DB      $01
        DB      $3E
        DB      $18
        DB      $DD
        DB      $36
        DB      $19
        DB      $18
        DB      $DD
        DB      $CB
        DB      $0C
        DB      $56
        DB      $28
        DB      $49
        DB      $CD
        DB      $BE
        DB      $2A
        DB      $35
        DB      $CD
        DB      $58
        DB      $2A
        DB      $DD
        DB      $CB
        DB      $13
        DB      $6E
        DB      $28
        DB      $0B
        DB      $3E
        DB      $53
        DB      $32
        DB      $F7
        DB      $4E
        DB      $3E
        DB      $10
        DB      $32
        DB      $F8
        DB      $4E
        DB      $C9
        DB      $3E
        DB      $07
        DB      $32
        DB      $F7
        DB      $4E
        DB      $3E
        DB      $08
        DB      $32
        DB      $F8
        DB      $4E
        DB      $DD
        DB      $CB
        DB      $13
        DB      $F6
        DB      $CD
        DB      $C4
        DB      $2A
        DB      $34
        DB      $46
        DB      $7E
        DB      $FE
        DB      $01
        DB      $20
        DB      $05
        DB      $21
        DB      $64
        DB      $00
        DB      $18
        DB      $07
        DB      $05
        DB      $21
        DB      $7D
        DB      $00
        DB      $29
        DB      $10
        DB      $FD
        DB      $E5
        DB      $DD
        DB      $75
        DB      $1F
        DB      $DD
        DB      $74
        DB      $20
        DB      $CD
        DB      $15
        DB      $2D
        DB      $C1
        DB      $18
        DB      $2A
        DB      $CD
        DB      $24
        DB      $29
        DB      $DD
        DB      $6E
        DB      $0F
        DB      $DD
        DB      $66
        DB      $10
        DB      $11
        DB      $0B
        DB      $00
        DB      $19
        DB      $7E
        DB      $B7
        DB      $C8
        DB      $06
        DB      $00
        DB      $4F
        DB      $DD
        DB      $CB
        DB      $0C
        DB      $6E
        DB      $28
        DB      $05
        DB      $CD
        DB      $B3
        DB      $2A
        DB      $18
        DB      $0B
        DB      $DD
        DB      $36
        DB      $09
        DB      $01
        DB      $DD
        DB      $36
        DB      $08
        DB      $00
        DB      $CD
        DB      $B8
        DB      $2A
        DB      $35
        DB      $3E
        DB      $01
        DB      $32
        DB      $A1
        DB      $4F
        DB      $CD
        DB      $D7
        DB      $2A
        DB      $09
        DB      $E5
        DB      $01
        DB      $50
        DB      $C3
        DB      $B7
        DB      $ED
        DB      $42
        DB      $30
        DB      $03
        DB      $E1
        DB      $18
        DB      $01
        DB      $C1
        DB      $EB
        DB      $73
        DB      $23
        DB      $72
        DB      $DD
        DB      $CB
        DB      $13
        DB      $76
        DB      $C8
        DB      $E1
        DB      $C9
        DB      $3A
        DB      $24
        DB      $4F
        DB      $B7
        DB      $28
        DB      $1A
        DB      $DD
        DB      $CB
        DB      $07
        DB      $6E
        DB      $20
        DB      $14
        DB      $CD
        DB      $80
        DB      $2F
        DB      $DD
        DB      $7E
        DB      $1B
        DB      $FE
        DB      $02
        DB      $CC
        DB      $43
        DB      $24
        DB      $DD
        DB      $CB
        DB      $01
        DB      $BE
        DB      $21
        DB      $25
        DB      $4F
        DB      $35
        DB      $C9
        DB      $DD
        DB      $7E
        DB      $1B
        DB      $FE
        DB      $02
        DB      $20
        DB      $06
        DB      $CD
        DB      $43
        DB      $24
        DB      $CD
        DB      $D4
        DB      $30
        DB      $CD
        DB      $88
        DB      $31
        DB      $DD
        DB      $6E
        DB      $0F
        DB      $DD
        DB      $66
        DB      $10
        DB      $11
        DB      $07
        DB      $00
        DB      $19
        DB      $5E
        DB      $23
        DB      $56
        DB      $EB
        DB      $DD
        DB      $7E
        DB      $02
        DB      $CD
        DB      $26
        DB      $2E
        DB      $DD
        DB      $7E
        DB      $1B
        DB      $DD
        DB      $CB
        DB      $07
        DB      $5E
        DB      $28
        DB      $3B
        DB      $DD
        DB      $36
        DB      $19
        DB      $03
        DB      $47
        DB      $DD
        DB      $7E
        DB      $06
        DB      $FE
        DB      $50
        DB      $78
        DB      $30
        DB      $0B
        DB      $3D
        DB      $20
        DB      $02
        DB      $3E
        DB      $03
        DB      $DD
        DB      $36
        DB      $06
        DB      $90
        DB      $18
        DB      $0B
        DB      $3C
        DB      $FE
        DB      $04
        DB      $38
        DB      $02
        DB      $3E
        DB      $01
        DB      $DD
        DB      $36
        DB      $06
        DB      $0A
        DB      $DD
        DB      $77
        DB      $1B
        DB      $78
        DB      $FE
        DB      $02
        DB      $20
        DB      $10
        DB      $DD
        DB      $5E
        DB      $03
        DB      $DD
        DB      $56
        DB      $04
        DB      $CB
        DB      $2A
        DB      $CB
        DB      $1B
        DB      $DD
        DB      $73
        DB      $03
        DB      $DD
        DB      $72
        DB      $04
        DB      $DD
        DB      $7E
        DB      $1B
        DB      $FE
        DB      $02
        DB      $C2
        DB      $95
        DB      $2F
        DB      $DD
        DB      $CB
        DB      $07
        DB      $66
        DB      $20
        DB      $12
        DB      $3A
        DB      $CF
        DB      $40
        DB      $DD
        DB      $BE
        DB      $06
        DB      $30
        DB      $06
        DB      $DD
        DB      $CB
        DB      $00
        DB      $B6
        DB      $18
        DB      $04
        DB      $DD
        DB      $CB
        DB      $00
        DB      $F6
        DB      $CD
        DB      $60
        DB      $24
        DB      $B7
        DB      $28
        DB      $0A
        DB      $CD
        DB      $A6
        DB      $2F
        DB      $B7
        DB      $28
        DB      $04
        DB      $DD
        DB      $CB
        DB      $07
        DB      $EE
        DB      $C3
        DB      $95
        DB      $2F
L3363:  DB      $01
        DB      $00
        DB      $00
        DB      $00
        DB      $AA
        DB      $AA
L3369:  DB      $02
        DB      $00
        DB      $00
        DB      $00
        DB      $AA
        DB      $55
L336F:  DB      $03
        DB      $00
        DB      $00
        DB      $00
        DB      $55
        DB      $55
L3375:  DB      $04
        DB      $00
        DB      $00
        DB      $55
        DB      $55
        DB      $55
L337B:  DB      $05
        DB      $00
        DB      $55
        DB      $55
        DB      $55
        DB      $55
L3381:  DB      $06
        DB      $55
        DB      $55
        DB      $55
        DB      $55
        DB      $55
L3387:  LD      B,$05
        LD      DE,$0028
        LD      A,$55
L338E:  CP      (HL)
        RET     Z
        ADD     HL,DE
        DJNZ    L338E
        RET     
        ;
L3394:  LD      A,($4F24)
        OR      A
        RET     NZ
        LD      A,($4F27)
        BIT     7,A
        PUSH    AF
        LD      A,($4EF6)
        JR      Z,L33C3
        BIT     7,A
        JR      NZ,L33B2
        LD      HL,$4BDF
        CALL    L3387
        ;
L33AE:  DB      $78
        DB      $3C
        DB      $18
        DB      $03
L33B2:  LD      A,($4F2D)
        LD      BC,$00C7
        LD      DE,$4BB8
        LD      HL,$4BB9
        LDIR    
        LD      C,A
        JR      L33E0
L33C3:  BIT     7,A
        JR      Z,L33D1
        LD      HL,$4BB8
        CALL    L3387
        LD      A,B
        INC     A
        JR      L33D4
L33D1:  LD      A,($4F2C)
L33D4:  LD      BC,$00C7
        LD      DE,$4C7F
        LD      HL,$4C7E
        LDDR    
        LD      C,A
L33E0:  EXX     
        SYSSUK  RANGED           ;  UPI RANGED random number
        DB      $00              ;  ... Cutoff = 0
        ;
        EXX     
        LD      HL,$4EF5
        LD      DE,L3369
        DEC     C
        JR      NZ,L33FB
        CP      $C0
        JR      C,L33F7
        LD      DE,L3363
        JR      L33F9
L33F7:  LD      (HL),$01
L33F9:  JR      L3468
L33FB:  DEC     C
        JR      NZ,L3414
        BIT     0,(HL)
        JR      Z,L3407
        LD      DE,L336F
        JR      L3412
L3407:  CP      $80
        JR      NC,L3410
        LD      DE,L3363
        JR      L3412
L3410:  LD      (HL),$01
L3412:  JR      L3468
L3414:  DEC     C
        JR      NZ,L342B
        BIT     0,(HL)
        JR      Z,L3420
        LD      DE,L3375
        JR      L3429
L3420:  CP      $80
        JR      C,L3429
        LD      DE,L3375
        LD      (HL),$01
L3429:  JR      L3468
L342B:  DEC     C
        JR      NZ,L3447
        BIT     0,(HL)
        JR      Z,L3442
        CP      $C0
        JR      NC,L343B
        LD      DE,L337B
        JR      L3440
L343B:  LD      DE,L336F
        LD      (HL),$00
L3440:  JR      L3445
L3442:  LD      DE,L336F
L3445:  JR      L3468
L3447:  DEC     C
        JR      NZ,L3463
        BIT     0,(HL)
        JR      Z,L345E
        CP      $C0
        JR      NC,L3457
        LD      DE,L3381
        JR      L345C
L3457:  LD      DE,L3375
        LD      (HL),$00
L345C:  JR      L3461
L345E:  LD      DE,L3375
L3461:  JR      L3468
L3463:  LD      DE,L337B
        LD      (HL),$00
L3468:  EX      DE,HL
        POP     AF
        LD      ($4EF6),A
        JR      Z,L3478
        LD      A,(HL)
        LD      ($4F2D),A
        LD      DE,$4BB7
        JR      L347F
L3478:  LD      A,(HL)
        LD      ($4F2C),A
        LD      DE,$4B90
L347F:  LD      B,$05
L3481:  PUSH    BC
        LD      BC,$0028
        INC     HL
        LD      A,(HL)
        EX      DE,HL
        ADD     HL,BC
        LD      (HL),A
        EX      DE,HL
        POP     BC
        DJNZ    L3481
        RET
        
L348F:  PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        EXX     
        EX      AF,AF'
        PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        PUSH    IY
        PUSH    IX
        LD      A,($4F1D)
        OR      A
        JR      NZ,L34A9
        LD      A,$F2
        OUT     ($04),A
        OUT     ($00),A
L34A9:  LD      A,($4F7C)
        OUT     ($0F),A
        LD      A,$4F
        LD      I,A
        LD      A,$88
        OUT     ($0D),A
        LD      A,($4F79)
        CP      $01
        JR      NZ,L34C2
        LD      A,$02
        LD      ($4F79),A
L34C2:  LD      A,($4FB1)
        OR      A
        JR      Z,L34D4
        LD      DE,L34D4
        LD      HL,$4FAF
        LD      (HL),E
        INC     HL
        LD      (HL),D
        JP      L23B1

L34D4:  EI      
        CALL    L2081
        LD      HL,$4F2A
        DEC     (HL)
        JP      NZ,$36C8
        LD      (HL),$03
        LD      IX,$40C9
        BIT     7,(IX+$01)
        JP      Z,$36C8
        CALL    $2443
        LD      A,($4F24)
        OR      A
        JR      Z,$3509
        BIT     4,(IX+$07)
        JR      NZ,$3509
        CALL    $2F80
        RES     7,(IX+$01)
        LD      HL,$4F25
        DEC     (HL)
        JP      $313B

L3509:  CALL    $3188
        BIT     4,(IX+$07)
        JP      NZ,$3692
        LD      HL,$4F28
        CALL    $2AD0
        IN      A,(C)
        PUSH    AF
        AND     $0F
        CP      (HL)
        JR      Z,$359D
        LD      DE,$0000
        BIT     0,A
        JR      Z,$352B
        LD      DE,$FE00
        BIT     1,A
        JR      Z,$3532
        LD      DE,$0200
        LD      (IX+$09),D
        LD      (IX+$08),E
        LD      C,A
        LD      A,($40DC)
        BIT     0,A
        JR      NZ,$355F
        LD      DE,$FE80
        BIT     3,C
        LD      A,$00
        JR      Z,$3555
        LD      DE,$0200
        BIT     3,(HL)
        JR      NZ,$3553
        LD      A,$01
        LD      B,A
        JR      $355D

L3555:  BIT     3,(HL)
        JR      Z,$355D
        LD      B,$00
        LD      A,$01
        JR      $357C

L355F:  LD      DE,$0180
        BIT     2,C
        LD      A,$00
        JR      Z,$3574
        LD      DE,$FE00
        BIT     2,(HL)
        JR      NZ,$3572
        LD      A,$01
        LD      B,A
        JR      $357C

L3574:  BIT     2,(HL)
        JR      Z,$357C
        LD      B,$00
        LD      A,$01
        OR      A
        JR      Z,$359D
        SET     3,(IX+$13)
        BIT     1,(IX+$13)
        JR      NZ,$358F
        LD      (IX+$04),D
        LD      (IX+$03),E
        LD      A,B
        OR      A
        JR      Z,$3599
        SET     4,(IX+$13)
        JR      $359D

L3599:  RES     4,(IX+$13)
        LD      HL,$4F29
        POP     AF
        LD      ($4F28),A
        BIT     4,A
        JR      Z,$35B3
        XOR     A
        CP      (HL)
        JR      NZ,$35B1
        LD      (HL),$01
        CALL    $2EAA
        JR      $35B5

L35B3:  LD      (HL),$00
        LD      HL,$40DC
        BIT     1,(HL)
        JR      Z,$35E1
        LD      C,(IX+$06)
        BIT     0,(HL)
        JR      Z,$35D3
        LD      A,$64
        CP      C
        JR      NC,$35D1
        RES     1,(HL)
        LD      ($4F2E),A
        XOR     A
        LD      ($4F28),A
        JR      $35E1

L35D3:  DB      $3E
        DB      $3C
        DB      $B9
        DB      $38
        DB      $09
        DB      $CB
        DB      $8E
        DB      $32
        DB      $2F
        DB      $4F
        DB      $AF
        DB      $32
        DB      $28
        DB      $4F
        DB      $3A
        DB      $28
        DB      $4F
        DB      $4F
        DB      $AF
        DB      $CB
        DB      $46
        DB      $20
        DB      $10
        DB      $CB
        DB      $51
        DB      $28
        DB      $0A
        DB      $CB
        DB      $C6
        DB      $DD
        DB      $CB
        DB      $00
        DB      $F6
        DB      $11
        DB      $00
        DB      $02
        DB      $3C
        DB      $18
        DB      $0E
        DB      $CB
        DB      $59
        DB      $28
        DB      $0A
        DB      $CB
        DB      $86
        DB      $DD
        DB      $CB
        DB      $00
        DB      $B6
        DB      $11
        DB      $00
        DB      $FE
        DB      $3C
        DB      $B7
        DB      $28
        DB      $14
        DB      $DD
        DB      $73
        DB      $03
        DB      $DD
        DB      $72
        DB      $04
        DB      $CB
        DB      $CE
        DB      $AF
        DB      $32
        DB      $28
        DB      $4F
        DB      $21
        DB      $2E
        DB      $4F
        DB      $36
        DB      $28
        DB      $23
        DB      $36
        DB      $78
        DB      $21
        DB      $23
        DB      $4F
        DB      $7E
        DB      $B7
        DB      $28
        DB      $1D
        DB      $35
        DB      $20
        DB      $0F
        DB      $DD
        DB      $CB
        DB      $13
        DB      $DE
        DB      $AF
        DB      $DD
        DB      $CB
        DB      $13
        DB      $66
        DB      $28
        DB      $01
        DB      $3C
        DB      $CD
        DB      $F0
        DB      $29
        DB      $FE
        DB      $20
        DB      $20
        DB      $07
        DB      $DD
        DB      $CB
        DB      $13
        DB      $DE
        DB      $CD
        DB      $D8
        DB      $29
        DB      $DD
        DB      $CB
        DB      $13
        DB      $5E
        DB      $28
        DB      $49
        DB      $11
        DB      $00
        DB      $00
        DB      $DD
        DB      $CB
        DB      $13
        DB      $9E
        DB      $3A
        DB      $23
        DB      $4F
        DB      $B7
        DB      $28
        DB      $0C
        DB      $FE
        DB      $20
        DB      $30
        DB      $05
        DB      $11
        DB      $04
        DB      $00
        DB      $18
        DB      $03
        DB      $11
        DB      $02
        DB      $00
        DB      $DD
        DB      $CB
        DB      $13
        DB      $66
        DB      $28
        DB      $07
        DB      $0E
        DB      $01
        DB      $21
        DB      $41
        DB      $28
        DB      $18
        DB      $05
        DB      $0E
        DB      $00
        DB      $21
        DB      $62
        DB      $28
        DB      $19
        DB      $3A
        DB      $23
        DB      $4F
        DB      $B7
        DB      $20
        DB      $06
        DB      $E5
        DB      $79
        DB      $CD
        DB      $9D
        DB      $29
        DB      $E1
        DB      $7E
        DB      $32
        DB      $20
        DB      $4F
        DB      $23
        DB      $7E
        DB      $32
        DB      $21
        DB      $4F
        DB      $DD
        DB      $36
        DB      $18
        DB      $01
        DB      $DD
        DB      $36
        DB      $17
        DB      $00
        DB      $CD
        DB      $D4
        DB      $30
        DB      $06
        DB      $01
        DB      $D9
        DB      $DD
        DB      $6E
        DB      $0F
        DB      $DD
        DB      $66
        DB      $10
        DB      $11
        DB      $07
        DB      $00
        DB      $19
        DB      $5E
        DB      $23
        DB      $56
        DB      $D5
        DB      $FD
        DB      $E1
        DB      $3E
        DB      $01
        DB      $01
        DB      $00
        DB      $00
        DB      $CD
        DB      $2F
        DB      $2E
        DB      $CD
        DB      $60
        DB      $24
        DB      $B7
        DB      $28
        DB      $0F
        DB      $06
        DB      $0A
        DB      $21
        DB      $64
        DB      $2A
        DB      $CD
        DB      $A6
        DB      $2F
        DB      $B7
        DB      $28
        DB      $04
        DB      $DD
        DB      $CB
        DB      $07
        DB      $EE
        DB      $CD
        DB      $95
        DB      $2F

L36C8:  LD      HL,$4EF4
        DEC     (HL)
        JR      NZ,$36ED
        LD      (HL),$02
        LD      IY,$2E94
        LD      IX,$4063
        LD      B,$06
        CALL    $2081
        PUSH    BC
        PUSH    IY
        CALL    $308E
        POP     IY
        LD      DE,$0011
        ADD     IX,DE
        POP     BC
        DJNZ    $36DD
        CALL    $208E
        LD      A,($4F2A)
        CP      $03
        JP      NZ,$313B
        LD      A,($40DC)
        LD      DE,$0000
        LD      HL,($4F26)
        BIT     7,H
        JR      Z,$3717
        BIT     0,A
        JR      Z,$3715
        BIT     4,A
        JR      Z,$3712
        LD      DE,$0040
        JR      $3715

L3712:  LD      DE,$0010
        JR      $3727

L3717:  BIT     0,A
        JR      NZ,$3727
        BIT     4,A
        JR      Z,$3724
        LD      DE,$FFC0
        JR      $3727

L3724:  LD      DE,$FFF0
        LD      A,E
        OR      A
        JR      Z,$372E
        ADD     HL,DE
        JR      $3768

L372E:  BIT     7,H
        PUSH    AF
        CALL    NZ,$2035
        LD      A,($40DC)
        BIT     4,A
        JR      Z,$3742
        LD      DE,$0040
        LD      B,$02
        JR      $3747

L3742:  LD      DE,$0010
        LD      B,$01
        LD      A,E
        NEG     
        LD      C,A
        LD      A,B
        LD      B,$FF
        CP      H
        JR      Z,$375B
        JR      C,$375B
        ADD     HL,DE
        CP      H
        JR      NZ,$3759
        LD      L,$00
        JR      $3764

L375B:  ADD     HL,BC
        CP      H
        JR      Z,$3764
        JR      C,$3764
        LD      H,A
        LD      L,$00
        POP     AF
        CALL    NZ,$2035
        LD      ($4F26),HL
        LD      A,H
        BIT     7,A
        JR      NZ,$3772
        NEG     
        ADD     A,$03
        LD      C,A
        LD      HL,$4F2B
        DEC     (HL)
        JP      NZ,$313B
        LD      (HL),C
        CALL    $3394
        JP      $313B

L3783:  PUSH    AF
        LD      A,$9F
        OUT     ($0F),A
        LD      A,$4F
        LD      I,A
        LD      A,$84
        OUT     ($0D),A
        LD      A,$72
        OUT     ($05),A
        OUT     ($01),A
        LD      A,$75
        OUT     ($06),A
        OUT     ($02),A
        LD      A,$07
        OUT     ($07),A
        OUT     ($03),A
        POP     AF
        EI      
        RET     

L37A5:  PUSH    AF
        LD      A,$B3
        OUT     ($0F),A
        LD      A,$4F
        LD      I,A
        LD      A,$82
        OUT     ($0D),A
        LD      A,($4F1D)
        OR      A
        JR      NZ,$37CE
        LD      A,$A3
        OUT     ($05),A
        LD      A,$77
        OUT     ($01),A
        LD      A,$62
        OUT     ($04),A
        OUT     ($00),A
        LD      A,$F0
        OUT     ($02),A
        LD      A,$A0
        OUT     ($06),A
        POP     AF
        EI      
        RET     

L37D1:  PUSH    AF
        LD      A,$18
        OUT     ($0F),A
        LD      A,$4F
        LD      I,A
        LD      A,$80
        OUT     ($0D),A
        LD      A,($4EF8)
        OR      A
        JR      Z,$37ED
        DEC     A
        LD      ($4EF8),A
        JR      Z,$37ED
        LD      A,($4EF7)
        OUT     ($00),A
        OUT     ($01),A
        OUT     ($02),A
        OUT     ($03),A
        OUT     ($04),A
        OUT     ($05),A
        OUT     ($06),A
        OUT     ($07),A
        POP     AF
        EI      
        RET     

L3800:  PUSH    AF
        LD      A,$6C
        OUT     ($0F),A
        LD      A,$4F
        LD      I,A
        LD      A,$7E
        OUT     ($0D),A
        LD      A,($4EF8)
        OR      A
        JR      NZ,$3817
        OUT     ($04),A
        OUT     ($00),A
        LD      A,$52
        OUT     ($05),A
        OUT     ($01),A
        LD      A,$F4
        OUT     ($06),A
        OUT     ($02),A
        LD      A,$76
        OUT     ($07),A
        OUT     ($03),A
        POP     AF
        EI      
        RET     
        
L382C:  DB      $00
        DB      $00
        DB      $01
        DB      $01
        DB      $00
        DB      $20
        DB      $80
        DB      $01
        DB      $00
        DB      $00
        DB      $00
        DB      $20
        DB      $05
        DB      $00
        DB      $00
        DB      $00
        DB      $31
        DB      $00
        DB      $00
        DB      $00
        DB      $00
        DB      $00
        DB      $2C
        DB      $38
        DB      $00
        DB      $00
        DB      $FF
        DB      $02
        DB      $00
        DB      $01
        DB      $20
        DB      $01
        DB      $03
        DB      $00
        DB      $00
        DB      $00
L3850:  CALL    $2081
        PUSH    HL
        PUSH    BC
        PUSH    IX
        POP     DE
        LD      C,$1F
        LD      HL,$3831
        LD      B,$00
        SYSTEM  MOVE             ;  UPI MOVE block transfer
        ;
        POP     BC
        LD      (IX+$0C),B
        LD      (IX+$1C),C
        POP     HL
        LD      (IX+$0F),L
        LD      (IX+$10),H
        BIT     4,(IX+$0C)
        JR      Z,L387A
        LD      A,$02
        LD      (IX+$1B),A
L387A:  LD      HL,$4F25
        INC     (HL)
        CALL    L208E
        BIT     4,(IX+$0C)
        JR      NZ,L3891
        LD      A,($4FAE)
        DEC     A
        LD      (IX+$14),A
        CALL    L2284
L3891:  RET     
        
;  Fill 16 bytes of RAM at $4011-$4020 with 0's
L3892:  SYSSUK  FILL             ;  UPI FILL memory with data
        DW      $4011            ;  ... Memory Address = 16401
        DW      $0010            ;  ... Byte Count = 16
        DB      $00              ;  ... Data = 0
        ;
        RET
             
L389A:  XOR     A
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        INC     HL
        EX      DE,HL
        INC     HL
        BIT     7,(HL)
        JR      NZ,$38AC
        DEC     HL
        PUSH    HL
        POP     IX
        INC     A
        LD      B,$01
        EX      DE,HL
        DJNZ    $389B
        RET     

L38B0:  BIT     5,(IX+$07)
        JP      NZ,$32A8
        LD      A,($4F24)
        OR      A
        JP      Z,$32A8
        LD      HL,$4017
        INC     (HL)
        JP      $32A8

L38C5:  LD      A,B
        LD      HL,($B001)
        JR      C,$385B
        DEC     H
        ADD     A,B
        LD      HL,($2533)
        RET     Z
L38D1:  LD      A,($4F24)
        OR      A
        JR      NZ,$3910
        LD      IX,$40E8
        BIT     7,(IX+$01)
        JR      NZ,$3910
        LD      HL,$4017
        LD      A,(HL)
        OR      A
        JR      Z,$3910
        DEC     (HL)
        LD      HL,$38C5
        LD      BC,$A3C0
        CALL    $3850
        SYSSUK  RANGED           ;  UPI RANGED random number
        DB      $80              ;  ... Cutoff = 128
        ;
        ADD     A,$14
        LD      (IX+$06),A
        AND     $1F
        ADD     A,$18
        LD      (IX+$0B),A
        AND     $01
        INC     A
        CP      $02
        JR      NZ,$3909
        INC     A
        LD      (IX+$1B),A
        SET     7,(IX+$01)
        LD      DE,$0803
        CALL    $20CB
        JP      $38D1

L3919:  DB      $64
        DB      $2A
        DB      $0A
        DB      $00
        DB      $00
        DB      $80
        DB      $27
        DB      $2E
        DB      $4F
        DB      $31
        DB      $27
        DB      $00
        DB      $DD
        DB      $CB
        DB      $13
        DB      $76
        DB      $28
        DB      $03
        DB      $C3
        DB      $88
        DB      $31
        DB      $3A
        DB      $24
        DB      $4F
        DB      $B7
        DB      $28
        DB      $0D
        DB      $DD
        DB      $CB
        DB      $07
        DB      $6E
        DB      $20
        DB      $07
        DB      $21
        DB      $18
        DB      $40
        DB      $34
        DB      $C3
        DB      $A8
        DB      $32
        DB      $3A
        DB      $1E
        DB      $4F
        DB      $B7
        DB      $C2
        DB      $A8
        DB      $32
        DB      $DD
        DB      $CB
        DB      $0C
        DB      $5E
        DB      $CA
        DB      $A8
        DB      $32
        DB      $DD
        DB      $CB
        DB      $13
        DB      $6E
        DB      $C2
        DB      $A8
        DB      $32
        DB      $DD
        DB      $CB
        DB      $13
        DB      $EE
        DB      $DD
        DB      $CB
        DB      $07
        DB      $EE
        DB      $C3
        DB      $A8
        DB      $32
        DB      $78
        DB      $2A
        DB      $04
        DB      $25
        DB      $39
        DB      $FB
        DB      $24
        DB      $80
        DB      $2A
        DB      $31
        DB      $27

L396C:  LD      A,($4F24)
        OR      A
        JR      NZ,$39C9
        LD      IX,$4042
        BIT     7,(IX+$01)
        JR      Z,$3984
        LD      IX,$4021
        BIT     7,(IX+$01)
        JR      NZ,$39C9
        LD      HL,$4018
        LD      A,(HL)
        OR      A
        JR      Z,$39C9
        DEC     (HL)
        LD      HL,$3961
        LD      BC,$0540
        CALL    $3850
        SYSSUK  RANGED           ;  UPI RANGED random number
        DB      $80              ;  ... Cutoff = 128
        ;
        ADD     A,$14
        LD      (IX+$06),A
        LD      (IX+$0B),$16
        CALL    $2AA9
        LD      A,(HL)
        SRL     A
        SRL     A
        CP      $20
        JR      NC,$39B1
        LD      A,$20
        ADD     A,$10
        LD      (IX+$08),A
        SYSSUK  RANGED           ;  UPI RANGED random number
        DB      $02              ;  ... Cutoff = 2
        ;
        INC     A
        CP      $02
        JR      NZ,$39BF
        INC     A
        LD      (IX+$1B),A
        SET     7,(IX+$01)
        CALL    $2A44
        CALL    $2AB8
        LD      A,(HL)
        CP      $07
        JR      C,$39D9
        SYSSUK  RANGED           ;  UPI RANGED random number
        DB      $18              ;  ... Cutoff = 24
;
        ADD     A,$10
        LD      D,A
        JR      $39DB

L39D9:  LD      D,$05
        LD      E,$06
        CALL    $20CB
        JP      $396C

L39E3:  PUSH    DE
        LD      A,($40D4)
        SUB     (IX+$0B)
        PUSH    AF
        JR      NZ,$39F2
        LD      DE,$0000
        JR      $39FB

L39F2:  JR      NC,$39FB
        LD      HL,$0000
        OR      A
        SBC     HL,DE
        EX      DE,HL
        LD      L,(IX+$08)
        LD      H,(IX+$09)
        ADD     HL,DE
        BIT     7,H
        PUSH    AF
        CALL    NZ,$2035
        LD      A,($4011)
        LD      D,A
        LD      A,H
        CP      D
        JR      C,$3A13
        LD      H,D
        LD      L,$00
        POP     AF
        CALL    NZ,$2035
        LD      (IX+$08),L
        LD      (IX+$09),H
        POP     AF
        POP     DE
        PUSH    AF
        LD      A,($40CF)
        SUB     (IX+$06)
        JR      NZ,$3A2D
        LD      DE,$0000
        JR      $3A36

L3A2D:  JR      NC,$3A36
        LD      HL,$0000
        OR      A
        SBC     HL,DE
        EX      DE,HL
        LD      L,(IX+$03)
        LD      H,(IX+$04)
        ADD     HL,DE
        BIT     7,H
        PUSH    AF
        CALL    NZ,$2035
        LD      A,($4013)
        LD      D,A
        LD      A,H
        CP      D
        JR      C,$3A4E
        LD      H,D
        LD      L,$00
        POP     AF
        CALL    NZ,$2035
        LD      (IX+$03),L
        LD      (IX+$04),H
        POP     AF
        RET     

L3A5A:  DB      $21
        DB      $CA
        DB      $40
        DB      $CB
        DB      $7E
        DB      $CA
        DB      $A8
        DB      $32
        DB      $CB
        DB      $7F
        DB      $28
        DB      $02
        DB      $ED
        DB      $44
        DB      $FE
        DB      $10
        DB      $DC
        DB      $F6
        DB      $2E
        DB      $C3
        DB      $A8
        DB      $32
        DB      $DD
        DB      $CB
        DB      $07
        DB      $6E
        DB      $C2
        DB      $A8
        DB      $32
        DB      $3A
        DB      $24
        DB      $4F
        DB      $B7
        DB      $28
        DB      $07
        DB      $21
        DB      $1A
        DB      $40
        DB      $34
        DB      $C3
        DB      $A8
        DB      $32
        DB      $DD
        DB      $7E
        DB      $1B
        DB      $FE
        DB      $02
        DB      $C2
        DB      $A8
        DB      $32
        DB      $DD
        DB      $35
        DB      $19
        DB      $C2
        DB      $A8
        DB      $32
        DB      $3A
        DB      $1E
        DB      $40
        DB      $DD
        DB      $77
        DB      $19
        DB      $ED
        DB      $5B
        DB      $1F
        DB      $40
        DB      $CD
        DB      $E3
        DB      $39
        DB      $08
        DB      $CD
        DB      $9F
        DB      $2A
        DB      $7E
        DB      $FE
        DB      $07
        DB      $DA
        DB      $A8
        DB      $32
        DB      $CD
        DB      $A4
        DB      $2A
        DB      $7E
        DB      $FE
        DB      $02
        DB      $DA
        DB      $A8
        DB      $32
        DB      $08
        DB      $C3
        DB      $5A
        DB      $3A
        DB      $78
        DB      $2A
        DB      $04
        DB      $70
        DB      $3A
        DB      $13
        DB      $26
        DB      $80
        DB      $2A
        DB      $31
        DB      $27
        DB      $19
        DB      $78
        DB      $2A
        DB      $04
        DB      $70
        DB      $3A
        DB      $C2
        DB      $25
        DB      $80
        DB      $2A
        DB      $31
        DB      $27
        DB      $0A
        DB      $0A
        DB      $95
        DB      $16
        DB      $43
        DB      $78
        DB      $2A
        DB      $04
        DB      $70
        DB      $3A
        DB      $BA
        DB      $28
        DB      $CE
        DB      $3A
        DB      $31
        DB      $27
        DB      $32
        DB      $C1
        DB      $41
        DB      $A2
        DB      $41
        DB      $83
        DB      $41
        DB      $64
        DB      $41
L3AE6:  DB      $3A
        DB      $24
        DB      $4F
        DB      $B7
        DB      $20
        DB      $62
        DB      $3A
        DB      $1A
        DB      $40
        DB      $B7
        DB      $28
        DB      $5C
        DB      $CD
        DB      $9F
        DB      $2A
        DB      $7E
        DB      $21
        DB      $DE
        DB      $3A
        DB      $C6
        DB      $01
        DB      $FE
        DB      $04
        DB      $38
        DB      $02
        DB      $3E
        DB      $04
        DB      $47
        DB      $CD
        DB      $9A
        DB      $38
        DB      $B7
        DB      $28
        DB      $46
        DB      $21
        DB      $1A
        DB      $40
        DB      $35
        DB      $CD
        DB      $9F
        DB      $2A
        DB      $7E
        DB      $FE
        DB      $03
        DB      $30
        DB      $05
        DB      $21
        DB      $C2
        DB      $3A
        DB      $18
        DB      $1B
        DB      $FF
        DB      $77
        DB      $03
        DB      $B7
        DB      $20
        DB      $05
        DB      $21
        DB      $B6
        DB      $3A
        DB      $18
        DB      $10
        DB      $CD
        DB      $9F
        DB      $2A
        DB      $7E
        DB      $FE
        DB      $05
        DB      $30
        DB      $05
        DB      $21
        DB      $C2
        DB      $3A
        DB      $18
        DB      $03
        DB      $21
        DB      $D2
        DB      $3A
        DB      $01
        DB      $80
        DB      $83
        DB      $CD
        DB      $50
        DB      $38
        DB      $3E
        DB      $95
        DB      $DD
        DB      $77
        DB      $06
        DB      $FF
        DB      $77
        DB      $20
        DB      $DD
        DB      $77
        DB      $08
        DB      $C6
        DB      $18
        DB      $DD
        DB      $77
        DB      $0B
        DB      $DD
        DB      $CB
        DB      $01
        DB      $FE
        DB      $11
        DB      $01
        DB      $04
        DB      $CD
        DB      $CB
        DB      $20
        DB      $C3
        DB      $E6
        DB      $3A
        DB      $DD
        DB      $CB
        DB      $07
        DB      $6E
        DB      $C2
        DB      $A8
        DB      $32
        DB      $3A
        DB      $24
        DB      $4F
        DB      $B7
        DB      $28
        DB      $07
        DB      $21
        DB      $19
        DB      $40
        DB      $34
        DB      $C3
        DB      $A8
        DB      $32
        DB      $DD
        DB      $7E
        DB      $1B
        DB      $FE
        DB      $02
        DB      $C2
        DB      $A8
        DB      $32
        DB      $DD
        DB      $35
        DB      $19
        DB      $C2
        DB      $A8
        DB      $32
        DB      $3A
        DB      $1B
        DB      $40
        DB      $DD
        DB      $77
        DB      $19
        DB      $ED
        DB      $5B
        DB      $1C
        DB      $40
        DB      $CD
        DB      $E3
        DB      $39
        DB      $08
        DB      $CD
        DB      $A4
        DB      $2A
        DB      $7E
        DB      $FE
        DB      $03
        DB      $DA
        DB      $A8
        DB      $32
        DB      $08
        DB      $C3
        DB      $5A
        DB      $3A
        DB      $78
        DB      $2A
        DB      $04
        DB      $57
        DB      $3B
        DB      $7C
        DB      $26
        DB      $80
        DB      $2A
        DB      $31
        DB      $27
        DB      $19
        DB      $78
        DB      $2A
        DB      $04
        DB      $57
        DB      $3B
        DB      $DD
        DB      $25
        DB      $80
        DB      $2A
        DB      $31
        DB      $27
        DB      $32
        DB      $45
        DB      $41
        DB      $26
        DB      $41
        DB      $07
        DB      $41

L3BB2:  LD      A,($4F24)
        OR      A
        JR      NZ,$3C01
        LD      A,($4019)
        OR      A
        JR      Z,$3C01
        CALL    $2A9F
        LD      A,(HL)
        INC     A
        LD      HL,$3BAC
        CP      $03
        JR      C,$3BCC
        LD      A,$03
        LD      B,A
        CALL    $389A
        OR      A
        JR      Z,$3C01
        LD      HL,$4019
        DEC     (HL)
        CALL    $2A9F
        LD      A,(HL)
        CP      $03
        JR      NC,$3BE4
        LD      HL,$3B94
        JR      $3BE7

L3BE4:  LD      HL,$3BA0
        LD      BC,$8380
        CALL    $3850
        LD      A,$95
        LD      (IX+$06),A
        SYSSUK  RANGED           ;  UPI RANGED random number
        DB      $20              ;  ... Cutoff = 32
        ;
        LD      (IX+$08),A
        ADD     A,$18
        LD      (IX+$0B),A
        SET     7,(IX+$01)
        LD      DE,$0502
        CALL    $20CB
        JP      $3BB2
        
L3C0A:  CALL    L2AA9
        LD      E,(HL)
        LD      D,$00
        SLA     E
        JR      NC,L3C17
        LD      DE,$0100
L3C17:  LD      ($401F),DE
        LD      A,(HL)
        LD      ($401C),A
        SRL     A
        SRL     A
        SRL     A
        NEG     
        ADD     A,$22
        LD      ($401B),A
        ADD     A,$03
        LD      ($401E),A
        LD      A,(HL)
        SRL     A
        NEG     
        ADD     A,$F0
        CP      $A0
        JR      NC,L3C3E
        LD      A,$A0
L3C3E:  LD      ($4F22),A
        LD      BC,$0202
        LD      DE,$0202
        LD      A,(HL)
        CP      $81
        JR      NC,L3C51
        LD      DE,$0101
        JR      L3C5B
        
L3C51:  CP      $41
        JR      NC,L3C5B
        LD      BC,$0101
        LD      DE,$0101
L3C5B:  LD      ($4013),BC
        LD      ($4011),DE
        RET     

L3C64:  SYSSUK  FILL             ;  UPI FILL memory with data
        DW      $4021            ;  ... Memory Address = 16417
        DW      $01BF            ;  ... Byte Count = 447
        DB      $00              ;  ... Data = 0
        ;
        RET     

L3C6C:  LD      A,($4F24)
        OR      A
        JP      NZ,L3C8E
        CALL    L2AB8
        LD      A,(HL)
        CALL    L2ABE
        ADD     A,(HL)
        OR      A
        JP      NZ,L3C8B
        INC     A
        LD      ($4F24),A
        CALL    L2ACA
        SET     7,(HL)
        CALL    L210E
L3C8B:  JP      L3E63

L3C8E:  LD      A,($4F25)
        OR      A
        JP      NZ,L3E63
        CALL    L2081
        CALL    L3C64
        CALL    L2B0B
        CALL    L208E
        CALL    L2ACA
        BIT     7,(HL)
        JP      Z,L3CEE
        LD      B,$00
        CALL    L2AC4
        LD      A,(HL)
        SRA     A
        LD      B,A
        CALL    L2A9F
        LD      A,(HL)
L3CB6:  SUB     $03
        JP      C,L3CD2
        JR      NZ,L3CB6
        CALL    L2AAE
        LD      A,(HL)
        CP      $09
        JP      Z,L3CD1
        PUSH    BC
        CALL    L2B01
        POP     BC
        CALL    L2C9B
        JP      L3CE8

L3CD1:  INC     B
L3CD2:  LD      A,B
        OR      A
        JR      Z,L3CEE
        LD      A,($4F1E)
        OR      A
        JP      Z,L3CE5
        CALL    L2AAE
        LD      A,(HL)
        DEC     A
        JP      Z,L3CEE
L3CE5:  CALL    L2CC8
L3CE8:  LD      DE,$0A04
        CALL    L20CB
L3CEE:  CALL    L2B01
        LD      A,($4F1E)
        OR      A
        JP      Z,L3D5C
        CALL    L2AAE
        DEC     (HL)
        PUSH    AF
        CALL    L2B01
        POP     AF
        JP      NZ,L3D3A
        CALL    L2ACA
        INC     (HL)
        LD      HL,$4016
        DEC     (HL)
        JP      NZ,L3D31
        CALL    L2D0F
        CALL    L2D4F
        LD      DE,$0A04
        CALL    L20CB
L3D1B:  LD      C,$10
        IN      A,(C)
        INC     C
        IN      D,(C)
        INC     C
        IN      E,(C)
        INC     C
        IN      B,(C)
        OR      B
        OR      E
        OR      D
        JP      Z,L3D1B
        JP      $0000            ; Reset System
        
L3D31:  CALL    L2D02
        LD      DE,$0A04
        CALL    L20CB
L3D3A:  LD      HL,$4F1F
        LD      A,($4FF3)
        INC     (HL)
        CP      (HL)
        JP      NZ,L3D47
        LD      (HL),$00
L3D47:  CALL    L2ACA
        LD      A,(HL)
        RES     7,A
        OR      A
        JP      NZ,L3D3A
        LD      A,($4FF3)
        CP      $01
        JP      Z,L3D5C
        LD      ($4015),A
L3D5C:  LD      A,$92
        OUT     ($0A),A
        LD      ($4F1D),A
        CALL    L2081
        CALL    L3C64
        CALL    L2B0B
        CALL    L2B13
        CALL    L2B7E
        CALL    L2B01
        CALL    L208E
        LD      A,$B6
        OUT     ($0A),A
        XOR     A
        LD      ($4F1D),A
        LD      A,$1C
        OUT     ($09),A
        LD      A,($4015)
        OR      A
        CALL    NZ,L2CF0
        CALL    L2ACA
        BIT     7,(HL)
        JP      Z,L3DF2
        RES     7,(HL)
        CALL    L2A9F
        INC     (HL)
        LD      A,(HL)
        LD      D,A
        LD      B,A
        PUSH    BC
        XOR     A
        LD      C,$05
L3DA0:  ADD     A,C
        DJNZ    L3DA0
        ADD     A,$05
        CP      $28
        JP      C,L3DAC
        LD      A,$28
L3DAC:  CALL    L2AB8
        LD      (HL),A
        CALL    L2AB3
        LD      A,(HL)
        LD      ($4017),A
        LD      (HL),A
        CALL    L2ABE
        LD      (HL),$04
        CALL    L2AC4
        LD      (HL),$00
        CALL    L2AA4
        LD      B,(HL)
        XOR     A
        LD      C,$18
L3DC9:  ADD     A,C
        DJNZ    L3DC9
        CALL    L2AA9
        LD      (HL),A
        POP     BC
        OR      A
        JP      Z,L3DE2
        XOR     A
        LD      C,$05
L3DD8:  ADD     A,C
        DJNZ    L3DD8
        ADD     A,(HL)
        JP      NC,L3DE1
        LD      A,$F0
L3DE1:  LD      (HL),A
L3DE2:  CALL    L2B7E
        LD      A,($4015)
        OR      A
        LD      DE,$0A04
        CALL    NZ,L20CB
        CALL    L2C49
L3DF2:  CALL    L2D39
        CALL    L2B7E
        LD      DE,$0204
        CALL    L20CB
        CALL    L2AD0
L3E01:  IN      A,(C)
        BIT     4,A
        JP      Z,L3E01
        CALL    L2B0B
        CALL    L3C0A
        CALL    L2AB8
        LD      A,(HL)
        SRA     A
        LD      ($4019),A
        JP      NC,L3E1B
        INC     A
L3E1B:  LD      ($401A),A
        CALL    L2ABE
        LD      A,(HL)
        LD      ($4018),A
        CALL    L2AB3
        LD      A,(HL)
        LD      ($4017),A
        SYSSUK  MOVE             ;  UPI MOVE block transfer
        DW      $4F2E            ;  ... Destination Address = 20270
        DW      $0004            ;  ... Byte Count = 4
        DW      L2A84            ;  ... Source Address = 10884
        ;
        CALL    L2994
        LD      A,$0F
        LD      ($4F28),A
        LD      ($4F29),A
        LD      HL,$FFFF
        LD      ($4F26),HL
        XOR     A
        LD      ($4F24),A
        LD      ($4F23),A
        LD      ($4F1E),A
        LD      ($4015),A
        LD      IX,$40C9
        LD      HL,$3919
        LD      BC,$91C0
        CALL    L3850
        SET     7,(IX+$01)
L3E63:  LD      DE,$0404
        CALL    L20CB
        JP      L3C6C
        ;
L3E6C:  CALL    L23C1
        JP      L2E4D
        ;
; Start "Cosmic Raiders"        
L3E72:  DI      
        LD      SP,$4FC0
        LD      A,$F0
        OUT     ($CC),A
        CALL    L2019

;  SELECT GAME Menu
;  Note: This routine expects the "SELECT GAME" string to be at
;  location $0DF3.  This is accurate for the majority of Bally Arcade/
;  Astrocade on-board ROMs, but NOT the "3164 ROM."  At this location in
;  the 3164 ROM are the last three letters of "SCRIBBLING" (ING followed
;  by $00 to end the string).  When COSMIC RAIDERS is run on a Bally Home
;  Library Computer with this early "3164 ROM,"" instead of displaying
;  "SELECT GAME" at the top of the menu, only "ING" is displayed.  
;    
L3E7D:  LD      DE,$0DF3         ;  ... Address of "SELECT GAME" in "3159 ROM"
        LD      HL,L3E85         ;  ... Address of Next Menu Node
        SYSTEM  MENU             ;  UPI display a MENU
        ;
L3E85:  DW      MENUST           ; ... Next Menu Node
L3E89:  DW      L2BBC            ; ... Choice 1 Text is "COSMIC RAIDER"
        DW      L3E8B            ; ... Start of "COSMIC RAIDERS" 

L3E8B:  SYSSUK  GETPAR           ;  UPI GET game PARameter from user
        DW      NOPLAY           ;  ... Prompt "# OF PLAYERS"
        DB      $01              ;  ... Digits = 1
        DW      NUMPLA           ;  ... Parameter Address = 20467
        ;
        DI      
        LD      A,(NUMPLA)       
        OR      A                ; Set Zero flag if NUMPLA=0                 
        JP      Z,L3E8B          ; If # of Players is 0, then ask again
        CP      $05              ; Subtract 5 from NUMPLA
        JP      NC,L3E8B         ; If # of Players > 4, then ask again 
        SYSSUK  GETPAR           ;  UPI GET game PARameter from user
        DW      L2BFC            ;  ... Prompt Address "# OF SHIPS"
        DB      $01              ;  ... Digits = 1
        DW      SHIPS            ;  ... Parameter Address = 20468
        ;
        DI      
        LD      A,(SHIPS)
        OR      A                ; Set Zero flag if SHIPS=0
        JP      Z,L3E8B          ; If # of Ships is 0, then ask # of Players 
        LD      DE,L2C08         ; String Address "PLAYER 1"
        LD      BC,L2BE5         ; String Address "INTENSITY      0 TO 9"
        LD      A,$01            ; Get 1 digit
        LD      HL,INTEN1        ; Storage for Player 1 Intensity Level
        SYSTEM  GETPAR           ;  UPI GET game PARameter from user
        ;
        LD      A,(NUMPLA)
        DEC     A                ; More than one player?
        JP      Z,L3EF9          ; If no more players, then stop asking           
        LD      DE,L2C12         ; String Address "PLAYER 2"
        LD      BC,L2BE5         ; String Address "INTENSITY      0 TO 9"
        LD      A,$01            ; Get 1 digit
        LD      HL,INTEN2        ; Storage for Player 2 Intensity Level
        SYSTEM  GETPAR           ;  UPI GET game PARameter from user
        ;
        LD      A,(NUMPLA)
        CP      $02              ; More than two players?
        JP      Z,L3EF9          ; If no more players, then stop asking
        LD      DE,L2C1C         ; String Address "PLAYER 3"
        LD      BC,L2BE5         ; String Address "INTENSITY      0 TO 9"
        LD      A,$01            ; Get 1 digit
        LD      HL,INTEN3        ; Storage for Player 3 Intensity Level
        SYSTEM  GETPAR           ;  UPI GET game PARameter from user
        ;
        LD      A,(NUMPLA)       
        CP      $03              ; More than three players?
        JP      Z,L3EF9          ; If no more players, then stop asking
        LD      DE,L2C26         ; String Address "PLAYER 4"
        LD      BC,L2BE5         ; String Address "INTENSITY      0 TO 9"
        LD      A,$01            ; Get 1 digit 
        LD      HL,INTEN4        ; Storage for Player 4 Intensity Level
        SYSTEM  GETPAR           ;  UPI GET game PARameter from user
        ;
L3EF9:  LD      A,$92
        OUT     (VERBL),A        ; write VERtical Blanking Line
        XOR     A                ; Zero-out Accumulator
        OUT     (COL0L),A        ; write COLor 0 Left (Black)
        SYSSUK  FILL             ;  UPI FILL memory with data
        DW      NORMEM           ;  ... Memory Address = 16384
        DW      $0F00            ;  ... Byte Count = 3840
        DB      $00              ;  ... Data = 0
        ;
        LD      SP,$4EF4
        LD      HL,(INTEN1)
        PUSH    HL
        LD      DE,(INTEN3)
        PUSH    DE
        SYSSUK  FILL             ;  UPI FILL memory with data
        DW      $4EF4            ;  ... Memory Address = 20212
        DW      $00D1            ;  ... Byte Count = 209
        DB      $00              ;  ... Data = 0
        ;
        CALL    L3892            ; Fill 16 bytes of RAM at $4011-$4020 with 0's
        ;
L3F1D:  POP     DE
        LD      (INTEN3),DE
        POP     HL
        LD      (INTEN1),HL
        LD      A,$01
        LD      ($4F1D),A
        LD      HL,L232C
        LD      ($4F86),HL
        LD      A,$70
        LD      ($4F7B),A
        LD      A,$93
        LD      ($4F7D),A
        LD      A,$F0
        LD      ($4F7C),A
        LD      A,$3C
        LD      ($4F7A),A
        LD      HL,(L227C)
        CALL    L21DE
        ;
L3F4B:  LD      HL,(L2280)
        CALL    L21DE
        LD      HL,L3783
        LD      ($4F8A),HL
        LD      HL,L37A5
        LD      ($4F84),HL
        LD      HL,L348F
        LD      ($4F82),HL
        LD      HL,L37D1
        LD      ($4F88),HL
        LD      HL,L3800
        LD      ($4F80),HL
        LD      HL,L23CD
        LD      ($4F7E),HL
        LD      A,$02
        LD      HL,$4F15
        LD      (HL),A
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),A
        LD      A,(SHIPS)
        LD      HL,$4F09
        LD      (HL),A
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),A
        LD      A,$80
        LD      HL,$4F01
        LD      (HL),A
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),A
        LD      B,$28
L3F9C:  PUSH    BC
        CALL    L3394
        ;
L3FA0:  POP     BC
        DJNZ    L3F9C
        LD      A,($4FF3)
        LD      ($4016),A
        LD      ($4F2A),A
        LD      ($4F2B),A
        LD      ($4EF4),A
        LD      ($4F24),A
        LD      ($4015),A
        CALL    L210E
        LD      A,$01
        LD      ($4FC2),A
        LD      HL,L3AE6
        LD      ($4FB4),HL
        LD      HL,L3BB2
        LD      ($4FB6),HL
        LD      HL,L38D1
        LD      ($4FB8),HL
        LD      HL,L3C6C
        LD      ($4FBA),HL
        LD      HL,L2B9E
        LD      ($4FBC),HL
        LD      HL,L396C
        LD      ($4FBE),HL
        LD      A,$01
        LD      ($4FD9),A
        LD      A,$04
        LD      ($4FD6),A
        LD      A,$08
        LD      ($4FD7),A
        LD      ($4FD8),A
        LD      ($4FDA),A
        LD      ($4FDB),A
        JP      L3E6C
        DB      $FF

End     ; 

Instructions from Astrocade Manual
----------------------------------

Astrocade, The Professional Videocade (TM), Cartridge

COSMIC RAIDERS  2019

In deep space lies the alien sector Larkin.  You are there on a mission to
obtain energy sources that have been seized by the evil Larkins.  Radar and a
superior guidance system help you avoid attacking fighters and Kamikaze ships.
The energy stars are near the Larkin command ship: you must retrieve them
before you can leave the enemy sector.

Copyright (C)1982 Astrocade, Inc.  All Rights Reserved

Designed & Programmed by Bob Ogdon
Audio by Scot L. Norris
Graphics by Julie Malan & Lisa Natting
Developed by Action Graphics


LOADING INSTRUCTIONS
 
1.  Turn on your Astrocade and TV set, then select channel 3 or 4.

2.  Connect the hand controls by inserting control #1 into the first jack on
    the back left side (as you face the front of the Astrocade).  From left
    to right, the jacks connect to players 1, 2, 4 and 3.

3.  Insert the game cartridge, label side up, into the cartridge slot.  Press
    it down firmly to lock it into position.

4.  Press the RESET button and the menu of games will be displayed. 


COSMIC RAIDERS (1-4 players)

An evil force, LARKIN, is attacking your base planet.  In every sector you
travel through, four bombs are dropped with a slew of fighters to ensure the
bombs will reach your planet.  By destroying the bombs, you can earn bonus
energy stars.  Energy stars are floating above the planet for your strategic
use.  By flying through one, you are energized with an invincible energy
shield to help you wipe out the enemy.


STARTING THE GAME

Choose Cosmic Raiders by pressing 1 on the keypad or by using remote game
selection (pull the trigger on hand control #1, turn the knob until 1 appears
on the screen, then pull the trigger again).

Enter the number of players (1, 2, 3 or 4).  Each player selects his level of
difficulty (0-9).  Level 0 is extremely easy and is the only level that does
not get harder as you play.  

Choose the number of ships you have at your command (1-9).  The number will
be the same for each player.


PLAYING THE GAME

The hand control functions for Cosmic Raiders are:
     
Trigger     Fires your missiles
Knob        Has no function
Joystick    Controls your acceleration and movement up and down,
            left to right. 

The object of the game is to reach the highest score by shooting down as many
enemy fighters as possible and destroying bombs for bonus energy stars.
Every 2 bombs destroyed in a sector gives you a bonus energy star.  Radar is
used to track in front of and behind your view.  Enemy fighters are shown in
white and bombs are shown in red.  Your ships and the energy stars are shown
in black.  "F" on the control panel tells you how many enemy fighters you
must destroy to complete a sector.  "S" on the control panel tells you how
many energy stars you have available to you.  The number farthest to the right
on the control panel tells you how many ships you have left.

You have completed a sector when all enemy fighters are destroyed.  When there
is more than 1 player, the next player will have his turn when one of your
ships is shot down.  Each player starts with 2 energy stars and whatever
number of ships have been selected.


SCORING

There are different types of enemy fighters.  Some of them fire missiles at
you, others are kamikaze ships and will try to crash into you.  The type of
fighter you hit determines the number of points scored.

Fighter    Fighter     Fighter     Fighter     Fighter     Energy Star

Type 1     (Type 2     (Type 3     (Type 4     (Type 5       (Energy
 Pic)        Pic)        Pic)        Pic)        Pic)        Star pic)

10 Points  25 Points   25 Points   50 Points   50 Points    200 Points

The number of bombs destroyed within a sector determines your super
bonus points:

                                               Bomb        
1st bomb    100 points                      
2nd bomb    250 points (+ Bonus Energy Star)   (Bomb         
3rd bomb    500 points                          pic) 
4th bomb  1,000 points (+ Bonus Energy Star)             

Energy stars can be saved up as you go from sector to sector.  At the end of
each sector, you receive an additional energy star for every 2 bombs you have
destroyed.  After every 3 sectors completed, you receive a bonus ship.  If
you have your maximum of 9 ships, you receive a bonus energy star instead.  
Every time you use an energy star you receive 200 extra points.


STRATEGIES FOR WINNING

Watch your radar for bombs and destroy them before they hit the ground to
earn high points and energy stars.

Try to succeed on as many levels as you can without using up any of your
energy stars.  Save them for meeting the tougher challenge of the higher
levels.  And remember -- an energy star only protects you for a limited 
period of time.  Try to use them when you can attack several fighters at 
once.  Don't forget: some of the enemy ships are kamikaze attackers.  They 
won't shoot but they move fast and will try to crash into you.  Watch your 
tail - fighters will sometimes shoot at you from behind.
     

PLAYING AGAIN

To play Cosmic Raiders again, any player may pull his trigger, or press the 
RESET button and follow the instructions for starting the game.
